<?php 
include "header.php"; 

$transcations_per_page = 500; 
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $transcations_per_page;

if (isset($_GET['filter_date'])) {
    $raw_filter_date = $_GET['filter_date'];

    if ($raw_filter_date === 'all') {
        $filter_date = ''; 
        $filter_sql = '';
    } elseif ($raw_filter_date === 'today') {
        $filter_date = date('Y-m-d');
        $filter_sql = " AND `date` = '$filter_date'";
    } else {
        $filter_date = mysqli_real_escape_string($conn, $raw_filter_date);
        $filter_sql = " AND `date` = '$filter_date'";
    }
} else {
    
    $filter_date = date('Y-m-d');
    $filter_sql = " AND `date` = '$filter_date'";
}

// $filter_sql = '';

// if (!empty($filter_date)) {
//     $filter_sql = " AND `date` = '$filter_date'";
// }
$query_string = '';

if (!empty($_GET['filter_date'])) $query_string .= '&filter_date=' . urlencode($_GET['filter_date']);
if (!empty($_GET['status'])) $query_string .= '&status=' . urlencode($_GET['status']);
if (!empty($_GET['type'])) $query_string .= '&type=' . urlencode($_GET['type']);
if (!empty($_GET['method'])) $query_string .= '&method=' . urlencode($_GET['method']);

$extra_filters = '';

if (!empty($_GET['status'])) {
    $status = mysqli_real_escape_string($conn, $_GET['status']);

    if (strtolower($status) === 'declined') {
        $extra_filters .= " AND transcations.status NOT IN ('Approved', 'SUCCESS', 'pending')";
    } else {
        $extra_filters .= " AND transcations.status = '$status'";
    }
}


if (!empty($_GET['type'])) {
    $type = mysqli_real_escape_string($conn, $_GET['type']);
    $extra_filters .= " AND transcations.type = '$type'";
}

if (!empty($_GET['method'])) {
    $method = mysqli_real_escape_string($conn, $_GET['method']);
    $extra_filters .= " AND transcations.inperson_online_check = '$method'";
}


if (!empty($_GET['filter_trx_type'])) {
    $trx_type = mysqli_real_escape_string($conn, $_GET['filter_trx_type']);
    $extra_filters .= " AND transcations.payment_type = '$trx_type'";
}

// Filter by Customer Name
if (!empty($_GET['filter_name'])) {
    $filter_name = mysqli_real_escape_string($conn, trim($_GET['filter_name']));
    $extra_filters .= " AND customers.name LIKE '%$filter_name%'";
}

// Filter by Account Number
if (!empty($_GET['filter_account_number'])) {
    $filter_account_number = mysqli_real_escape_string($conn, trim($_GET['filter_account_number']));
    // $extra_filters .= " AND customer_accounts.account_number LIKE '%$filter_account_number%'";
        $extra_filters .= " AND (customer_accounts.account_number LIKE '%$filter_account_number%' OR transcations.transaction_id LIKE '%$filter_account_number%')";

}

$filter_sql .= $extra_filters;

$date_query = "SELECT DISTINCT `date` FROM `transcations` WHERE `user_id` > 0  ORDER BY `date` DESC";
$date_result = mysqli_query($conn, $date_query);
$available_dates = [];

while ($row = mysqli_fetch_assoc($date_result)) {
    $available_dates[] = $row['date'];
}

// Count total records
// $count_query = "SELECT COUNT(*) AS total FROM `transcations` WHERE `user_id`>'0' $filter_sql";

$count_query = "SELECT COUNT(*) AS total 
                FROM `transcations` 
                LEFT JOIN `customers` ON transcations.user_id = customers.id
                LEFT JOIN `customer_accounts` ON customer_accounts.customer_id = customers.id
                WHERE transcations.user_id > 0
                $filter_sql
                AND transcations.status != 'Error'";
$total_records_result = mysqli_query($conn, $count_query);
$total_records_row = mysqli_fetch_assoc($total_records_result);
$total_records = $total_records_row['total'];
$total_pages = ceil($total_records / $transcations_per_page);

// Fetch paginated transactions
$sql_transcations = "SELECT 
    transcations.*, 
    transcations.payment_type, 
    transcations.inperson_online_check,
    transcations.type,
    customers.name AS customer_name,
    customers.phone AS customer_phone,
    customers.id AS customer_id,
    customer_accounts.account_number as customer_account_number
    FROM `transcations`
    LEFT JOIN `customers` ON transcations.user_id = customers.id
    LEFT JOIN `customer_accounts` ON customer_accounts.customer_id = customers.id
    WHERE transcations.user_id > 0 
    $filter_sql 
    AND transcations.status != 'Error'
    ORDER BY transcations.id DESC
    LIMIT $offset, $transcations_per_page";
$result_transcations = mysqli_query($conn, $sql_transcations);

// echo "$sql_transcations";
?>

<style>
    /* Target input[type="date"] and its calendar picker in dark mode */
        .dark-theme input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(1); /* This inverts the icon color */
        }
        
        /* Ensure other styling for the form-control stays */
        .dark-theme .form-control {
            color: #dde3ea;
            background-color: var(--dark-theme);
            border-color: rgba(222, 228, 236, 0.07) !important;
        }
        
        
        select.form-control {
        width: 100% !important;
    }

    @media (max-width: 768px) {
        .col-md-4.mt-2 select.form-control {
            width: 100% !important;
            min-width: 100%;
        }
    }
    
     #file-datatable {
        table-layout: auto;
        width: 100%; 
    }

    
    #file-datatable td, #file-datatable th {
        word-wrap: break-word;
        white-space: normal; 
        padding: 8px; 
    }


    #file-datatable th {
        font-weight: bold;
        text-align: left;
    }

    #file-datatable th:nth-child(9), #file-datatable td:nth-child(9) {
        /*max-width: none; */
    }
    
    .table thead th{
    color: #37374e !important;
    font-size: 11px !important;
    }
   
</style>




<div class="container" >
  <div class="row">
    <div class="col-lg-12">
      <div class="card ">
        <div class="card-body">
       <div class="row" style="align-items: end; margin-bottom:1rem;">
           <form method="GET" id="dateFilterForm" class="row" style="align-items: end; margin-bottom:1rem;">
      <div class="col-md-9 mt-2">
        <h3 class="card-title">Daily Reports<br>
            <span style="font-size: 12px;">
                <?php 
                echo ($filter_date === '') 
                    ? 'All Dates' 
                    : date('m/d/Y', strtotime($filter_date)); 
                ?>
            </span>
        </h3>
    </div>
    <div class="col-md-3 mt-2">
        <button type="button" class="btn btn-secondary btn-block" id="excel_file" style="width:auto; margin-left:auto;">Export to Excel</button>
    </div>

    <div class="col-md-12 mt-4"></div>

    <!-- Filter Date -->
    <div class="col-md-2 mt-2">
        <b>Date:</b><br>
        <select class="form-control" name="filter_date" form="dateFilterForm" >
            <option value="today" <?= (!isset($_GET['filter_date']) || $_GET['filter_date'] === 'today') ? 'selected' : ''; ?>>Today</option>
            <option value="all" <?= (isset($_GET['filter_date']) && $_GET['filter_date'] === 'all') ? 'selected' : ''; ?>>All Dates</option>
            <?php foreach ($available_dates as $date): ?>
                <option value="<?= $date ?>" <?= ($filter_date == $date) ? 'selected' : ''; ?>>
                    <?= date('m/d/Y', strtotime($date)) ?>
                </option>
            <?php endforeach; ?>
        </select>
    </div>
<div class="col-md-2 mt-2">
    <b>Customer Name:</b><br>
    <input type="text" class="form-control" name="filter_name" value="<?= $_GET['filter_name'] ?? ''; ?>" placeholder="Customer Name">
</div>

<!-- Account Number -->
<div class="col-md-2 mt-2">
    <b>Account No./ Transaction ID:</b><br>
    <input type="text" class="form-control" name="filter_account_number" value="<?= $_GET['filter_account_number'] ?? ''; ?>" placeholder="Search Account Number/ Transaction ID">
</div>
    <!-- Status -->
    <div class="col-md-1 mt-2">
        <b>Status:</b><br>
        <select class="form-control" name="status" form="dateFilterForm" >
            <option value="">All</option>
            <option value="approved" <?= ($_GET['status'] ?? '') === 'approved' ? 'selected' : '' ?>>Approved</option>
            <option value="declined" <?= ($_GET['status'] ?? '') === 'declined' ? 'selected' : '' ?>>Declined</option>
            <option value="pending" <?= ($_GET['status'] ?? '') === 'pending' ? 'selected' : '' ?>>Pending</option>
        </select>
    </div>

    <!-- Type -->
    <div class="col-md-1 mt-2">
        <b>Method:</b><br>
        <select class="form-control" name="type" form="dateFilterForm" >
            <option value="">All</option>
            <option value="nmi" <?= ($_GET['type'] ?? '') === 'nmi' ? 'selected' : '' ?>>Card</option>
            <option value="green" <?= ($_GET['type'] ?? '') === 'green' ? 'selected' : '' ?>>Echeck</option>
            <option value="cash" <?= ($_GET['type'] ?? '') === 'cash' ? 'selected' : '' ?>>Cash</option>
        </select>
    </div>

    <!-- Method -->
    <div class="col-md-1 mt-2">
        <b>Payment Type:</b><br>
        <select class="form-control" name="method" form="dateFilterForm" >
            <option value="">All</option>
            <option value="In-Person" <?= ($_GET['method'] ?? '') === 'In-Person' ? 'selected' : '' ?>>In Person</option>
            <option value="Online" <?= ($_GET['method'] ?? '') === 'Online' ? 'selected' : '' ?>>Online</option>
        </select>
    </div>

    <!-- Recurring/Single -->
    <div class="col-md-1 mt-2">
        <b>Type:</b><br>
        <?php $selected_trx_type = $_GET['filter_trx_type'] ?? ''; ?>
        <select class="form-control" name="filter_trx_type" form="dateFilterForm" >
            <option value="">All</option>
            <option value="recurring" <?= $selected_trx_type == 'recurring' ? 'selected' : '' ?>>Recurring</option>
            <option value="single_payment" <?= $selected_trx_type == 'single_payment' ? 'selected' : '' ?>>Single Payment</option>
        </select>
    </div>
    
       <div class="col-md-2 mt-2">
        <br>
        <button type="submit" class="btn btn-primary btn-block" style="margin-left:auto;">Apply Filters</button>
         </div>
    
    <div class="col-md-12">
        <div class="row">
            <div class="col-md-2 mt-4">
             <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($_GET['filter_date'])) $query_string .= '&filter_date=' . urlencode($_GET['filter_date']);
                        if (!empty($_GET['status'])) $query_string .= '&status=' . urlencode($_GET['status']);
                        if (!empty($_GET['type'])) $query_string .= '&type=' . urlencode($_GET['type']);
                        if (!empty($_GET['method'])) $query_string .= '&method=' . urlencode($_GET['method']);
                        if (!empty($_GET['filter_trx_type'])) $query_string .= '&filter_trx_type=' . urlencode($_GET['filter_trx_type']);
                        if (!empty($_GET['filter_name'])) $query_string .= '&filter_name=' . urlencode($_GET['filter_name']);
                        if (!empty($_GET['filter_account_number'])) $query_string .= '&filter_account_number=' . urlencode($_GET['filter_account_number']);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                        </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>
            </div>
        </div>
    </div>
 
    <!-- Hidden Form -->
    <!--<form method="GET" id="dateFilterForm"></form>-->
    </form>
</div>

                    <div class="table-responsive" bis_skin_checked="1">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer" role="grid" aria-describedby="file-datatable_info">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Transaction id</th>
                                <th>Card</th>
                                <th>Amount</th>
                                <th>Fee</th>
                                <th>Total</th>
                                <th>Method</th>
                                <th>Status</th>
                                <th>Payment Type</th>
                                <th>Action</th>
                                
                                <!--<th>Method</th>-->
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $A_amount_without_fee = 0;
                                $A_fee_amount = 0;
                                $A_amount = 0;
                                $counter = $offset+1;
                                if (mysqli_num_rows($result_transcations) > 0) {
                                  // output data of each row
                                  while($row_transcations = mysqli_fetch_assoc($result_transcations)) {
                                    $transaction_id  = $row_transcations['transaction_id'];
                                    $amount  = (float)$row_transcations['amount'];
                                    $card  = $row_transcations['card'];
                                    $date  = $row_transcations['date'];
                                    $customer_phone = $row_transcations['customer_phone'];
                                    if(!empty($customer_phone)){
                                        $customer_phone = str_replace("-","",$customer_phone);
                                        $customer_phone = preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $customer_phone);
                                        $customer_phone = "<br><i style='color:gray'>Phone: $customer_phone<i>";
                                    }
                                    $customer_account_number = $row_transcations['customer_account_number'];
                                    if(!empty($customer_account_number)){
                                        $customer_account_number = "<br><i style='color:gray'>Acc. # : $customer_account_number<i>";
                                    }
                                    $fee_amount  = $row_transcations['fee_amount'];
                                    $amount_without_fee  = $row_transcations['amount_without_fee'];
                                    
                                    $amount = str_replace(",","",$amount);
                                    $fee_amount = str_replace(",","",$fee_amount);
                                    $amount_without_fee = str_replace(",","",$amount_without_fee);
                                    $time  = $row_transcations['time'];
                                    
                                    // Combine date and time to form a complete datetime string
                                    $dateTimeString = $date . ' ' . $time;
                                    
                                    // Convert the combined string to a timestamp
                                    $timestamp = strtotime($dateTimeString);
                                    
                                    // Format date in US format (mm/dd/yyyy)
                                    $formatted_date = date('m/d/Y', $timestamp);
                                    
                                    // Format time in 12-hour format (hh:mm:ss AM/PM)
                                    $formatted_time = date('h:i A', $timestamp);
                                    $A_amount_without_fee = $A_amount_without_fee + $amount_without_fee;
                                    $A_fee_amount = $A_fee_amount + $fee_amount;
                                    $A_amount = $A_amount + $amount;
                                    
                                    
                                     $payment_type  = $row_transcations['payment_type'];
                                     
                                    $inperson_online_check  = $row_transcations['inperson_online_check'];
                                    
                                    $type_  = $row_transcations['type'];
                                    
                                     $payment_type_des = '';
                                        if($type_=='nmi'){
                                            $payment_type_des = 'Card';
                                        }elseif($type_=='green'){
                                            $payment_type_des = 'eCheck';
                                        }elseif($type_=='cash'){
                                            $payment_type_des = 'Cash';
                                        }

                            ?>
                                <tr>
                                <td><?php echo $counter; ?></td>
                                <td><?php echo $row_transcations['customer_name'].$customer_phone.$customer_account_number; ?></td>
                                <td><?php echo $formatted_date; ?></td>
                                <td><?php echo $formatted_time; ?></td>
                                <td><?php echo $transaction_id; ?></td>
                                <td><?php echo $card; ?></td>
                                <td>$<?php echo $amount_without_fee; ?></td>
                                <td>$<?php echo $fee_amount; ?></td>
                                <td>$<?php echo $amount ? number_format($amount, 2) : '0.00'; ?></td>
                                 <td><?php echo $payment_type_des; ?></td>
                                <td><?php echo $row_transcations['status']; ?></td>
                                 <td><?php echo ucwords(str_replace('_', ' ', $payment_type)) ?><br><b><i><?php echo ucwords(str_replace('_', ' ', $inperson_online_check))  ?></i></b></td>
                                <!--<td><?php echo $inperson_online_check;  ?></td>-->
                                <td><a target="_blank" href="download_invoice.php?id=<?php echo $row_transcations['id'] ; ?>&transcation_id=<?php echo $transaction_id; ?>" title="Print">
                                      <i class="fas fa-print" style="color:red;"></i>
                                </a></td>
                                </tr>
                                <?php 
                                    $counter++;
                                  }
                                  
                                  
                                  ?>
                                  
                                
                                <tr style="font-weight:900">
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td >Total : </td>
                                <td>$<?php echo number_format($A_amount_without_fee, 2); ?></td>
                                <td>$<?php echo number_format($A_fee_amount, 2); ?></td>
                                <td>$<?php echo $A_amount ? number_format($A_amount, 2) : '0.00'; ?></td>
                                <td></td>
                                </tr>
                                </b>
                                  <?php
                                }
                                
                                else {
                                    echo '<tr><td colspan="10" class="text-center text-danger">';
                                    if ($filter_date === date('Y-m-d')) {
                                        echo 'No transactions found for today.';
                                    } elseif ($filter_date !== '') {
                                        echo 'No transactions found for ' . date('m/d/Y', strtotime($filter_date)) . '.';
                                    } else {
                                        echo 'No transactions found.';
                                    }
                                    echo '</td></tr>';
                                }
                                ?>
                        </tbody>
                    </table>
                    <!-- Pagination -->
                    <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($_GET['filter_date'])) $query_string .= '&filter_date=' . urlencode($_GET['filter_date']);
                        if (!empty($_GET['status'])) $query_string .= '&status=' . urlencode($_GET['status']);
                        if (!empty($_GET['type'])) $query_string .= '&type=' . urlencode($_GET['type']);
                        if (!empty($_GET['method'])) $query_string .= '&method=' . urlencode($_GET['method']);
                        if (!empty($_GET['filter_trx_type'])) $query_string .= '&filter_trx_type=' . urlencode($_GET['filter_trx_type']);
                        if (!empty($_GET['filter_name'])) $query_string .= '&filter_name=' . urlencode($_GET['filter_name']);
                        if (!empty($_GET['filter_account_number'])) $query_string .= '&filter_account_number=' . urlencode($_GET['filter_account_number']);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                        </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>

                </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php 
include "footer_above_section.php"; 
include "footer.php"; 
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
document.getElementById('excel_file').addEventListener('click', function () {
    let table = document.getElementById('file-datatable');
    let excelData = [];

    for (let row of table.rows) {
        let rowData = [];
        for (let cell of row.cells) {
            rowData.push(cell.innerText.trim());
        }
        excelData.push(rowData);
    }

    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.aoa_to_sheet(excelData);
    XLSX.utils.book_append_sheet(wb, ws, "Accounts");

    let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

    function s2ab(s) {
        let buf = new ArrayBuffer(s.length);
        let view = new Uint8Array(buf);
        for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    let link = document.createElement('a');
    link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
    link.download = 'accounts_data.xlsx';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
});
</script>
