<?php

// error_reporting(E_ALL);
// ini_set('display_errors', 1);
include('header.php');
include('functions.php');

$customer_id = "";
$customer_name_result = "";
$customer_email_result = "";
$customer_account_result = "";
$customer_balance_result = ""; 
$customer_address_result = "";
$customer_phone_result = "";
$search_done = false;

$random_id = date('Ymdhis');

if (isset($_GET['submit'])) {
    $search_input = trim($_GET['customer_full_name']);
    $selected_customer_id = $_GET['selected_customer_id'] ?? '';

    if (!empty($selected_customer_id)) {
        $sql = "SELECT c.id, c.name, c.email, ca.account_number, ca.balance, c.address, c.phone
                FROM customers c
                JOIN customer_accounts ca ON c.id = ca.customer_id
                WHERE c.id = ?
                LIMIT 1";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("i", $selected_customer_id);
    } else {
        $sql = "SELECT c.id, c.name, c.email, ca.account_number, ca.balance, c.address, c.phone
                FROM customers c
                JOIN customer_accounts ca ON c.id = ca.customer_id
                WHERE c.name LIKE CONCAT('%', ?, '%') 
                   OR c.email LIKE CONCAT('%', ?, '%') 
                   OR ca.account_number LIKE CONCAT('%', ?, '%')
                   OR c.address LIKE CONCAT('%', ?, '%')
                    OR c.phone LIKE CONCAT('%', ?, '%')
                LIMIT 1";

        $stmt = $conn->prepare($sql);
        $stmt->bind_param("sssss", $search_input, $search_input, $search_input, $search_input, $search_input);
    }

    $stmt->execute();
    $result = $stmt->get_result();
    $search_done = true;

    if ($result && $result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $customer_id = $row['id'];
        $customer_name_result = $row['name'];
        $customer_email_result = $row['email'];
        $customer_account_result = $row['account_number'];
        $customer_balance_result = ($row['balance'] < 0) ? 0 : $row['balance'];
        $customer_address_result = $row['address'];
        $customer_phone_result = $row['phone'];

    }
}

if (isset($_POST['pay_now'])) {
    $customer_id = $_POST['customer_id'];
    $amount = (float) $_POST['payment_amount'];

    if ($amount <= 0) {
        echo "<div class='alert alert-danger mt-3'>Payment amount should be greater than 0.</div>";
    } else {
        $up_description = "Cash Payment";
        $up_amount_without_tax = number_format($amount, 2, '.', '');
        $up_fee = "0.00";
        $up_amount_with_tax = number_format($amount, 2, '.', '');


        $DateTime = date('Y-m-d H:i:s'); 
        $Date     = date('Y-m-d');     
        $Time     = date('H:i:s');      

        $sql_insert = "INSERT INTO `transcations`
            (`date_time`, `amount_without_fee`, `fee_amount`, `transaction_id`, `status`, `amount`, `date`, `time`, `user_id`, `type`, `user_type`, `inperson_online_check`, `created_by`) 
            VALUES 
            ('$DateTime', '$up_amount_without_tax', '$up_fee', '$random_id', 'Approved', '$up_amount_with_tax', '$Date', '$Time', '$customer_id', 'cash', 'customer', 'In-person', '$customer_id')";
                if (mysqli_query($conn, $sql_insert)) {
                            $last_inserted_transcation_db_id = mysqli_insert_id($conn);

                    echo "<div class='alert alert-success mt-3'>Cash payment recorded successfully!</div>";
                    echo '
                <iframe id="invoiceFrame"
                src="download_invoice.php?id=' . $last_inserted_transcation_db_id . '&transcation_id=' . $random_id . '"
                style="display:none;"
                onload="this.contentWindow.print();">
                </iframe>';
                }
                
                
else {
            echo "<div class='alert alert-danger mt-3'>Error: " . mysqli_error($conn) . "</div>";
        }
    }
}


?>
<style>
    #name_suggestions {
    position: absolute;
    top: 100%; 
    left: 0;
    width: 100%;
    z-index: 999;
    max-height: 255px;
    overflow-y: auto;
    background-color: white;
    /*border: 1px solid #ced4da;*/
    box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
}

.customer_cash_payment_total_payment_dollar {
  background: url("data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg' width='12' height='16'%3E%3Ctext x='0' y='11.9' fill='%23817ba7' font-size='14' font-family='Arial'%3E$%3C/text%3E%3C/svg%3E") no-repeat 10px center;
  background-size: 13px 16px;
  padding-left: 20px !important;
}
</style>

<div class="container mt-4">
    <!-- Customer Search -->
    <div class="card shadow-sm mb-4">
        <div class="card-header">
            <h4>Search Customer</h4>
        </div>
        <div class="card-body">
            <form method="GET" action="">
                
                     <input type="hidden" name="selected_customer_id" id="selected_customer_id">

                    <div class="row mb-3 position-relative" style=" align-items: flex-end; ">
                      <div class="col-md-11">
                        <label class="form-label">Search Customer by Name, Email, Account Number, Address or Phone</label>
                        
                        <div class="position-relative">
                            <input type="text" name="customer_full_name" id="customer_full_name" class="form-control" autocomplete="off" required>
                            <div id="name_suggestions" class="list-group"></div>
                        </div>
                    </div>
    
                    <div class="col-md-1">
                            <button type="submit" name="submit" class="btn btn-primary">Search</button>
                    </div>
                </div>
                
            </form>
        </div>
    </div>

    <?php if ($search_done): ?>
        <?php if (!empty($customer_name_result)): ?>
            <div class="card shadow-sm">
                <div class="card-header">
                    <h4>Customer Found</h4>
                </div>
                <div class="card-body">
                    <form method="POST" action="">
                        <input type="hidden" name="customer_id" value="<?php echo $customer_id; ?>">
                    
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <label class="form-label">Full Name</label>
                                <input type="text" value="<?php echo $customer_name_result; ?>" class="form-control" readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Email</label>
                                <input type="text" value="<?php echo $customer_email_result; ?>" class="form-control" readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Account Number</label>
                                <input type="text" value="<?php echo $customer_account_result; ?>" class="form-control" readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Address</label>
                                <input type="text" value="<?php echo $customer_address_result; ?>" class="form-control" readonly>
                            </div>
                           <div class="col-md-2">
                                <label class="form-label">Phone</label>
                                <input type="text" value="<?php echo $customer_phone_result; ?>" class="form-control" readonly>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">Payment Amount ($)</label>
                            <input type="number" step="0.01" name="payment_amount" 
                                   value="<?php echo number_format((float)$customer_balance_result, 2, '.', ''); ?>" 
                                   class="form-control customer_cash_payment_total_payment_dollar" required>
                            </div>
                        </div>
                    
                        <button type="submit" name="pay_now" class="btn btn-primary">Pay with Cash</button>
                    </form>
                </div>
            </div>
        <?php else: ?>
            <div class="alert alert-danger">No customer found with the given details.</div>
        <?php endif; ?>
    <?php endif; ?>
</div>

<script>

document.addEventListener('DOMContentLoaded', function () {
    const input = document.getElementById('customer_full_name');
    const suggestions = document.getElementById('name_suggestions');
    const customerIdField = document.getElementById('selected_customer_id');

    input.addEventListener('input', function () {
        const query = this.value;

        if (query.length < 1) {
            suggestions.innerHTML = '';
            customerIdField.value = '';
            return;
        }

        fetch('search_customer.php?term=' + encodeURIComponent(query))
            .then(res => res.json())
            .then(data => {
                suggestions.innerHTML = '';

                if (data.length > 0) {
                    data.forEach(item => {
                        const div = document.createElement('div');
                        div.className = 'list-group-item list-group-item-action';

                        const phone = item.phone && item.phone.trim() !== '' ? item.phone : 'No phone';
                        const address = item.address && item.address.trim() !== '' ? item.address : 'No address';


                        div.innerHTML = `
                            <div><strong>${item.name} | <i style="color:light-gray; font-size:12px !important;">${item.account}</i></strong></div>
                            <div><strong style="color:light-gray; font-size:12px;">${item.email}</strong></div>
                            <div style="font-size:12px;"><i>Phone: ${phone}</i> | <i>Address: ${address}</i></div>
                        `;

                        div.addEventListener('click', function () {
                            input.value = item.name;
                            customerIdField.value = item.id;
                            suggestions.innerHTML = '';
                        });

                        suggestions.appendChild(div);
                    });
                } else {
                    suggestions.innerHTML = '<div class="list-group-item text-muted">No matches found</div>';
                }
            });
    });

    document.addEventListener('click', function (e) {
        if (!input.contains(e.target) && !suggestions.contains(e.target)) {
            suggestions.innerHTML = '';
        }
    });
});


</script>


<?php include('footer.php'); ?>