<?php 
include 'header.php'; 

// Date calculations
$current_date = date("Y-m-d");
$yesterday_date = date('Y-m-d', strtotime('-1 day'));
$befor_30_days_date = date('Y-m-d', strtotime('-30 days'));
$first_day_of_month = date('Y-m-01');
$last_day_of_month = date('Y-m-t');

// Error handling for database connections
if (!$conn) {
    die("Database connection failed: " . mysqli_connect_error());
}

// Function to safely fetch single value from query
function fetchSingleValue($conn, $query) {
    $result = mysqli_query($conn, $query);
    if (!$result || mysqli_num_rows($result) == 0) {
        return 0;
    }
    $row = mysqli_fetch_assoc($result);
    return $row[array_key_first($row)] ?? 0;
}

// Total Customers
$total_customers = fetchSingleValue($conn, "SELECT COUNT(*) AS total_customers FROM `customers` where status = 'Active'");

// Today's Collection data
$collection_data = [
    'today' => 0,
    'yesterday' => 0,
    'month' => 0,
    'last_30_days' => 0,
    'total' => 0,
    'today_count' => 0,
    'month_count' => 0
];

// Get all collection data in one query for efficiency
 $collection_query = "
    SELECT 
        SUM(CASE WHEN `date` = '$current_date' AND status IN ('successful', 'Approved','') THEN `amount_without_fee` ELSE 0 END) AS today,
        SUM(CASE WHEN `date` = '$yesterday_date' AND status IN ('successful', 'Approved') THEN `amount_without_fee` ELSE 0 END) AS yesterday,
        SUM(CASE WHEN `date` >= '$first_day_of_month' AND `date` <= '$last_day_of_month' AND status IN ('successful', 'Approved') THEN `amount_without_fee` ELSE 0 END) AS month,
        SUM(CASE WHEN `date` >= '$befor_30_days_date' AND status IN ('successful', 'Approved') THEN `amount_without_fee` ELSE 0 END) AS last_30_days,
        SUM(CASE WHEN status IN ('successful', 'Approved') THEN `amount_without_fee` ELSE 0 END) AS total,
        COUNT(CASE WHEN `date` = '$current_date' THEN 1 END) AS today_count,
        COUNT(CASE WHEN `date` >= '$first_day_of_month' AND `date` <= '$last_day_of_month' THEN 1 END) AS month_count
    FROM `transcations` 
";

$collection_result = mysqli_query($conn, $collection_query);
if ($collection_result && mysqli_num_rows($collection_result)) {
    $collection_data = mysqli_fetch_assoc($collection_result);
}

// Calculate percentage changes
$today_percentage_change = 0;
if ($collection_data['yesterday'] > 0) {
    $today_percentage_change = (($collection_data['today'] - $collection_data['yesterday']) / $collection_data['yesterday']) * 100;
}

$month_percentage_change = 0;
$last_month_start = date('Y-m-01', strtotime('-1 month'));
$last_month_end = date('Y-m-t', strtotime('-1 month'));
$last_month_total = fetchSingleValue($conn, "
    SELECT SUM(`amount_without_fee`) 
    FROM `transcations` 
    WHERE `date` >= '$last_month_start' 
    AND `date` <= '$last_month_end'
    AND `amount_without_fee` > 0
    AND status IN ('successful', 'Approved')
");

if ($last_month_total > 0) {
    $month_percentage_change = (($collection_data['month'] - $last_month_total) / $last_month_total) * 100;
}


// Total Uncollected Payments
$total_uncollected_payments = fetchSingleValue($conn, "SELECT ((SELECT SUM(balance) FROM customer_accounts where balance > 0)) AS total_uncollected_payments ");



// Today's Customer Balance
$today_customer_balance = fetchSingleValue($conn, "
    SELECT SUM(`balance`) as today_customer_balance 
    FROM `customer_accounts` 
    WHERE `last_update` LIKE '%$current_date%' AND balance > 0
");

// Percentage Collected Today (compared to total collection)
$percentage_collected_today = 0;
if ($collection_data['total'] > 0) {
    $percentage_collected_today = ($collection_data['today'] / $collection_data['total']) * 100;
}
?> 

<div class="row row-sm">
  <div class="col-md-12 col-lg-12 col-xl-12">
    <!-- row -->
    <div class="row row-sm">
        
      <!-- Total Customers Card -->
      <a href="manage_customer.php" class="col-xl-4 col-lg-6 col-md-6 col-sm-12"><div>
        <div class="card">
          <div class="card-body iconfont text-start">
            <div class="d-flex justify-content-between">
              <h4 class="card-title mb-3">Registered Customers</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <div class="d-flex mb-0">
              <div class="">
                <h4 class="mb-1 font-weight-bold"><?php echo number_format($total_customers); ?></h4>
                <p class="mb-2 tx-12 text-muted">All registered customers</p>
              </div>
              <div class="card-chart bg-primary-transparent brround ms-auto mt-0">
                <i class="typcn typcn-group-outline text-primary tx-24"></i>
              </div>
            </div>
          </div>
        </div>
      </div></a>
      <a class="col-sm-12 col-md-6 col-lg-6 col-xl-4" href="transaction_history.php?from_date=<?php echo $current_date; ?>&to_date=<?php echo $current_date; ?>&search_name=&search_filter="><div >
        <div class="card">
          <div class="card-body">
            <div class="card-order">
              <h6 class="card-title mb-4">Transactions - Today</h6>
              <h2 class="text-start">
                <span><?php echo number_format($collection_data['today_count']); ?></span>
                <i class="mdi mdi-cash-multiple icon-size float-end text-primary text-primary-shadow"></i>
              </h2>
            </div>
          </div>
        </div>
      </div>
      </a>
      <a class="col-sm-12 col-md-6 col-lg-6 col-xl-4" href="transaction_history.php?from_date=<?php echo $first_day_of_month; ?>&to_date=<?php echo $current_date; ?>&search_name=&search_filter=" ><div>
        <div class="card">
          <div class="card-body">
            <div class="card-widget">
              <h6 class="card-title mb-4">Transactions - Month to Date</h6>
              <h2 class="text-start">
                <span><?php echo number_format($collection_data['month_count']); ?></span>
                <i class="mdi mdi-poll-box icon-size float-end text-warning text-warning-shadow"></i>
              </h2>
            </div>
          </div>
        </div>
      </div></a>
      <!-- Today's Collection Card -->
      <a href="transaction_history.php?from_date=<?php echo $current_date; ?>&to_date=<?php echo $current_date; ?>&search_name=&search_filter=" class="col-xl-4 col-lg-6 col-md-6 col-sm-12"><div >
        <div class="card">
          <div class="card-body iconfont text-start">
            <div class="d-flex justify-content-between">
              <h4 class="card-title mb-3">Collections - Today</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <div class="d-flex mb-0">
              <div class="">
                <h4 class="mb-1 font-weight-bold">$<?php echo number_format($collection_data['today'], 2); ?> 
                  <span class="<?php echo ($today_percentage_change >= 0) ? 'text-success' : 'text-danger'; ?> tx-13 ms-2">
                  </span>
                </h4>
                <p class="mb-2 tx-12 text-muted">Amount collected today</p>
              </div>
              <div class="card-chart bg-pink-transparent brround ms-auto mt-0">
                <i class="typcn typcn-chart-line-outline text-pink tx-24"></i>
              </div>
            </div>
          </div>
        </div>
      </div></a>
      <a class="col-sm-12 col-md-6 col-lg-6 col-xl-4" href="transaction_history.php?from_date=<?php echo $first_day_of_month; ?>&to_date=<?php echo $current_date; ?>&search_name=&search_filter=" ><div>
        <div class="card">
          <div class="card-body iconfont text-start py-4" >
            <div class="d-flex justify-content-between">
              <h4 class="card-title mb-3">Collection - Month to Date</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <div class="d-flex mb-0">
              <div class="">
                <h4 class="mb-1 font-weight-bold">$<?php echo number_format($collection_data['month'], 2); ?>
                  <span class="<?php echo ($month_percentage_change >= 0) ? 'text-success' : 'text-danger'; ?> tx-13 ms-2">
                  </span>
                </h4>
              </div>
              <div class="card-chart bg-teal-transparent brround ms-auto mt-0">
                <i class="typcn typcn-chart-bar-outline text-teal tx-20"></i>
              </div>
            </div>
            
          </div>
        </div>
      </div></a>
      <a href="#" class="col-xl-4 col-lg-6 col-md-6 col-sm-12">
      <div>
        <div class="card">
          <div class="card-body iconfont text-start">
            <div class="d-flex justify-content-between">
              <h4 class="card-title mb-3">Outstanding Receivables - this month</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <div class="d-flex mb-0">
              <div class="">
                <h4 class="mb-1 font-weight-bold">$<?php echo number_format($total_uncollected_payments, 2); ?></h4>
                <p class="mb-2 tx-12 text-muted">Outstanding payments</p>
              </div>
              <div class="card-chart bg-pink-transparent brround ms-auto mt-0">
                <i class="ti-pulse project bg-pink-transparent text-pink"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
      </a>

      <a class="col-sm-12 col-md-6 col-lg-6 col-xl-4 d-none" href="transaction_history.php?from_date=<?php echo $befor_30_days_date; ?>&to_date=<?php echo $current_date; ?>&search_name=&search_filter=" ><div>
        <div class="card">
          <div class="card-body" style="padding: 35px;">
            <div class="row">
              <div class="col">
                <div class="card-title">Rolling 30-Day Collections</div>
                <div class="h3 mt-2 mb-2">
                  <b>$<?php echo number_format($collection_data['last_30_days'], 2); ?></b>
                </div>
              </div>
              <div class="col-auto align-self-center">
                <div class="feature mt-0 mb-0">
                  <i class="ti-stats-up project bg-success-transparent text-success"></i>
                </div>
              </div>
            </div>
            
          </div>
        </div>
      </div></a>
      <a class="col-sm-6 col-lg-6 col-xl-4" href ="#"><div>
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col">
                <div class="card-title">Collection Rate - Today</div>
                <div class="h3 mt-2 ">
                  <b><?php echo number_format($percentage_collected_today, 2); ?>%</b>
                </div>
              </div>
              <div class="col-auto align-self-center">
                <div class="feature mt-0 mb-0">
                  <i class="fe fe-percent project bg-primary-transparent text-primary"></i>
                </div>
              </div>
            </div>
            <div class="progress progress-sm h-1 mb-1">
              <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo min($percentage_collected_today, 100); ?>%"></div>
            </div>
            <small class="mb-0 text-muted">Collections - Today<span class="float-end text-muted"><?php echo number_format($percentage_collected_today, 2); ?>% of total</span></small>
          </div>
        </div>
      </div></a>
      <a class="col-sm-6 col-lg-6 col-xl-4" href ="#"><div>
        <div class="card">
          <div class="card-body">
            <div class="row">
              <div class="col">
                  <?php
                  $collection_month_to_date_rate = ($collection_data['month'] / $total_uncollected_payments)*100;
                  
                  ?>
                <div class="card-title mb-1">Collection Rate - Month to date</div>
                <div class="h3 mt-2 ">
                  <b><?php echo number_format($collection_month_to_date_rate, 2); ?>%</b>
                </div>
              </div>
              <div class="col-auto align-self-center">
                <div class="feature mt-0 mb-0">
                  <i class="fe fe-percent project bg-primary-transparent text-primary"></i>
                </div>
              </div>
            </div>
            <div class="progress progress-sm h-1 mb-1">
              <div class="progress-bar bg-primary" role="progressbar" style="width: <?php echo min($collection_month_to_date_rate, 100); ?>%"></div>
            </div>
            <small class="mb-0 text-muted">Collections - Month to Date<span class="float-end text-muted"><?php echo number_format($collection_month_to_date_rate, 2); ?>% of total</span></small>
          </div>
        </div>
      </div></a>
      <a href="#" class="col-xl-4 col-lg-6 col-md-6 col-sm-12">
      <div>
        <div class="card">
          <div class="card-body iconfont text-start py-4">
            <div class="d-flex justify-content-between">
              <h4 class="card-title mb-3">Outstanding Receivables - Total</h4>
              <i class="mdi mdi-dots-vertical"></i>
            </div>
            <div class="d-flex mb-0">
              <div class="">
                <h4 class="mb-1 font-weight-bold">$<?php echo number_format($total_uncollected_payments, 2); ?></h4>
                <p class="mb-2 tx-12 text-muted">Outstanding payments</p>
              </div>
              <div class="card-chart bg-pink-transparent brround ms-auto mt-0">
                <i class="ti-pulse project bg-pink-transparent text-pink"></i>
              </div>
            </div>
          </div>
        </div>
      </div>
      </a>

    </div>
    

   
  </div>
</div>

<?php include 'footer.php'; ?>