<?php 

$confirm_uha = $_GET['confirm_uha'];

if ($confirm_uha === 'YES') {
    include "connection.php";

    // Prepare file paths
    $filename = 'export_' . date('Ymd_His') . '.csv';
    $filePath = __DIR__ . "/exports/$filename"; // adjust 'exports' folder as needed

    // Ensure exports directory exists
    if (!file_exists(__DIR__ . "/exports")) {
        mkdir(__DIR__ . "/exports", 0777, true);
    }

    // Open output streams
    $output = fopen('php://output', 'w'); // for browser download
    $saveFile = fopen($filePath, 'w');    // for saving to server

    // Set headers for download
    header('Content-Type: text/csv');
    header("Content-Disposition: attachment; filename=\"$filename\"");

    // Output headers
    $headers = ['account', 'date', 'userdefined', 'paymentamount', 'status', 'error', 'reference'];
    fputcsv($output, $headers);
    fputcsv($saveFile, $headers);

    // Query transactions
    $query = "SELECT transcations.*, accounts.account_number, accounts.old_account 
              FROM transcations 
              LEFT JOIN customer_accounts as accounts ON accounts.customer_id = transcations.user_id 
              WHERE transcations.tyler_export = '0' AND (transcations.status = 'Approved' OR transcations.status = 'SUCCESS')";
    $result = mysqli_query($conn, $query);

    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $transcations_id = $row['id'];
            mysqli_query($conn, "UPDATE transcations SET tyler_export = '1' WHERE id = '$transcations_id'");
            
            $amount = (float)str_replace("USD", "", $row['amount_without_fee']);

            $csvRow = [
                $row['account_number'],
                $row['date'],
                $row['old_account'],
                $amount,
                $row['status'],
                'no',
                $row['transaction_id']
            ];

            fputcsv($output, $csvRow);
            fputcsv($saveFile, $csvRow);
        }
    }

    // Close streams
    fclose($output);
    fclose($saveFile);
    exit;
}
