<?php 
include 'header.php';

$search = "";
$where = "1=1"; 

if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $search = trim(urldecode($_GET['search']));
    $search_lower = strtolower($search);

    
    $search_terms = preg_split('/\s+/', $search_lower);

    $name_conditions = [];
    foreach ($search_terms as $term) {
        $term_esc = mysqli_real_escape_string($conn, $term);
        $name_conditions[] = "(LOWER(ap.first_name) LIKE '%$term_esc%' OR LOWER(ap.last_name) LIKE '%$term_esc%')";
    }
    $name_condition_str = implode(' AND ', $name_conditions);

    $phone_search = preg_replace("/\D/", "", $search);
    
    $escaped_search = mysqli_real_escape_string($conn, $search);

    $where_parts = [];
    if (!empty($name_condition_str)) {
        $where_parts[] = "($name_condition_str)";
    }
    $where_parts[] = "LOWER(ap.email) LIKE '%" . mysqli_real_escape_string($conn, $search_lower) . "%'";
    $where_parts[] = "LOWER(ap.interval_frequency) LIKE '%" . mysqli_real_escape_string($conn, $search_lower) . "%'";
    $where_parts[] = "ap.start_date LIKE '%$escaped_search%'";
    $where_parts[] = "ap.creation_date LIKE '%$escaped_search%'";
    $where_parts[] = "LOWER(CONCAT(ap.first_name, ' ', ap.last_name)) LIKE '%" . mysqli_real_escape_string($conn, $search_lower) . "%'";
    $where_parts[] = "LOWER(c.name) LIKE '%" . mysqli_real_escape_string($conn, $search_lower) . "%'";
    $where_parts[] = "c.email LIKE '%$escaped_search%'";
    if (!empty($phone_search)) {
        $where_parts[] = "REPLACE(REPLACE(REPLACE(REPLACE(c.phone, ' ', ''), '-', ''), '(', ''), ')', '') LIKE '%$phone_search%'";
    }
    $where_parts[] = "LOWER(ca.account_number) LIKE '%" . mysqli_real_escape_string($conn, $search_lower) . "%'";

    $where = "(" . implode(' OR ', $where_parts) . ")";
}



if (isset($_GET['type']) && ($_GET['type'] == 'card' || $_GET['type'] == 'echeck')) {
    $type = mysqli_real_escape_string($conn, $_GET['type']);
    $where .= " AND ap.type = '$type'";
}

// Pagination setup
$auto_payments_per_page = 100;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $auto_payments_per_page;

$total_count_query = "SELECT COUNT(*) as total FROM `auto_payments` ap 
LEFT JOIN customers c ON c.id = ap.user_id 
LEFT JOIN customer_accounts ca ON ca.customer_id = c.id 
WHERE $where";
$total_count_result = mysqli_query($conn, $total_count_query);
$total_count_row = mysqli_fetch_assoc($total_count_result);
$total_records = $total_count_row['total'];
$total_pages = ceil($total_records / $auto_payments_per_page);

// Main query with JOINs
$query_auto_payments = "
SELECT 
    ap.*, 
    t.status AS latest_status, 
    (
        SELECT t2.date 
        FROM transcations t2 
        WHERE t2.reference_number = CONCAT('INV-', ap.id) 
          AND t2.payment_type = 'recurring' 
        ORDER BY t2.id DESC 
        LIMIT 1
    ) AS last_payment_date, 
    (
        SELECT t2.time 
        FROM transcations t2 
        WHERE t2.reference_number = CONCAT('INV-', ap.id) 
          AND t2.payment_type = 'recurring' 
        ORDER BY t2.id DESC 
        LIMIT 1
    ) AS last_payment_time,
    c.name AS customer_name, 
    c.phone AS customer_phone,
    c.email AS customer_email,
    ca.account_number as customer_account_number
FROM auto_payments ap
LEFT JOIN (
    SELECT t1.* 
    FROM transcations t1 
    INNER JOIN (
        SELECT reference_number, MAX(id) as max_id 
        FROM transcations 
        GROUP BY reference_number
    ) t2 ON t1.id = t2.max_id
) t ON t.reference_number = CONCAT('INV-', ap.id)
LEFT JOIN customers c ON c.id = ap.user_id
LEFT JOIN customer_accounts ca ON ca.customer_id = c.id
WHERE $where
ORDER BY ap.id DESC
LIMIT $offset, $auto_payments_per_page";

$result_query_auto_payments = mysqli_query($conn, $query_auto_payments);



function addOrdinalSuffix($day) {
    $day = (int)$day;
    if (!in_array(($day % 100), [11, 12, 13])) {
        switch ($day % 10) {
            case 1:  return $day . 'st';
            case 2:  return $day . 'nd';
            case 3:  return $day . 'rd';
        }
    }
    return $day . 'th';
}
?>
<style>
    .card-header i{
        display:block !important;
    }
</style>
<!-- HTML remains the same except input form and display -->
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-6">
                        <h3 class="card-title">Manage Auto Payments</h3>
                    </div>
                    <div class="col-md-6">
                          <form method="GET" class="mb-3">
                                <div class="input-group">
                                    <input type="text" name="search" class="form-control" placeholder="Search by name, email, phone, frequency, account #..." value="<?php echo htmlspecialchars($search); ?>">
                                    
                                    <select name="type" class="form-select" style="max-width: 120px;">
                                        <option value="">All</option>
                                        <option value="card" <?php echo (isset($_GET['type']) && $_GET['type'] == 'card') ? 'selected' : ''; ?>>Card</option>
                                        <option value="echeck" <?php echo (isset($_GET['type']) && $_GET['type'] == 'echeck') ? 'selected' : ''; ?>>E-Check</option>
                                    </select>
                                    
                                    <button type="submit" class="btn btn-primary">Search</button>
                                </div>
                           </form>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-12">
                        <ul class="pagination">
                            <?php
                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page - 1) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . $i . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page + 1) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Amount</th>
                                <th>Email</th>
                                <th>Start Date</th>
                                <th>Frequency</th>
                                <th>Method</th>
                                <th>Subscription Since</th>
                                <th>Last Payment</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_query_auto_payments)) {
                                $customer_details_id = $row['id'];
                                $card_type = $row['type'];
                                $subscription_response_des = "";

                                $customer_phone = $row['customer_phone'];
                                if (!empty($customer_phone)) {
                                    $customer_phone = preg_replace("/[^0-9]/", "", $customer_phone);
                                    if (strlen($customer_phone) === 10) {
                                        $customer_phone = preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $customer_phone);
                                        $customer_phone = "<br><i style='color:gray'>$customer_phone</i>";
                                    }
                                }

                                $customer_account_number = $row['customer_account_number'];
                                $subscription_response = $row['subscription_response'];

                                if ($subscription_response !== 'Subscription added' && $card_type == 'card') {
                                    $subscription_response_des = "<br><span style='font-size:8px;font-weight:900;color:red'>".$subscription_response."</span>";
                                }

                                echo "<tr>
                                    <td>{$counter}</td>
                                    <td>" . htmlspecialchars($row['first_name']) . " " . htmlspecialchars($row['last_name']) . "$customer_phone$subscription_response_des</td>
                                    <td><b>Amount:</b> $" . htmlspecialchars($row['amount_without_fee']) . " <br> <b>Fee:</b> $" . htmlspecialchars($row['fee_amount']) . "</td>
                                    <td>Email: " . htmlspecialchars($row['email']) . "<br>Acc. # $customer_account_number</td>
                                    <td>" . htmlspecialchars(date('m/d/Y', strtotime($row['start_date']))) . "</td>
                                    <td>" . htmlspecialchars(addOrdinalSuffix($row['day_of_month'])) . " of each month</td>
                                    <td>" . htmlspecialchars($row['type'] == 'echeck' ? 'eCheck' : ucwords($row['type'])) . "</td>
                                    <td>" . htmlspecialchars(date('m/d/Y', strtotime($row['creation_date']))) . "</td>
                                    <td>" . (
                                        !empty($row['latest_status'])
                                            ? (
                                                strtolower($row['latest_status']) === 'approved'
                                                    ? "<span class='badge bg-success'>" . htmlspecialchars($row['latest_status']) . "</span>"
                                                    : "<span class='badge bg-warning text-dark'>" . htmlspecialchars($row['latest_status']) . "</span>"
                                            )
                                            : "<span class='badge bg-secondary'>No Payment</span>"
                                    ) .
                                    (
                                        !empty($row['last_payment_date']) && !empty($row['last_payment_time'])
                                            ? "<br><small class='text-muted'>" .
                                                (strtolower($row['latest_status']) === 'activity limit exceeded' ? "Last Attempted On:" : "Last Payment On:") .
                                                "<br>" .
                                                date('m/d/Y', strtotime($row['last_payment_date'])) .
                                                " at " .
                                                date('h:i A', strtotime($row['last_payment_time'])) .
                                                "</small>"
                                            : ""
                                    ) . "</td>
                                    <td><b><a href='view_subscription_details.php?id=$customer_details_id' style='color:green'>All Transactions</a><br><a href='view_subscription_details.php?id=$customer_details_id'>View Details</a></b></td>
                                </tr>";
                                $counter++;
                            }
                            ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <ul class="pagination">
                            <?php
                            if ($current_page > 1) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page - 1) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                    </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . $i . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?search=' . urlencode($search) . '&page=' . ($current_page + 1) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
