<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this API?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['api_id'])) {
    $api_id = (int) $_GET['api_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `nmi_api_settings` SET `is_active`='0' WHERE `id`='$api_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Success!</strong> API deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the API.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_nmi_setting.php?api_id=' . $api_id . '&confirm=yes"; }</script>';
    }
}

$apis_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $apis_per_page;

$query_apis = "SELECT * FROM `nmi_api_settings` WHERE is_active = 1 ORDER BY id DESC LIMIT $apis_per_page OFFSET $offset";
$result_apis = mysqli_query($conn, $query_apis);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage NMI API Settings</h3>
                    </div>
                    <div class="col-md-4 d-none">
                        <a class="btn btn-outline-primary float-end" href="add-nmi-api.php" title="Add New API">Add New API</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>URL</th>
                                <th>API Key</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_apis)) {
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['url']); ?></td>
                                    <td><?php echo htmlspecialchars($row['api_key']); ?></td>
                                    <td>
                                        <a href="update_nmi_setting.php?id=<?php echo $row['id']; ?>"><i class="si si-note" title="Update"></i></a>
                                        <a href="manage_nmi_setting.php?api_id=<?php echo $row['id']; ?>"><i class="si si-close" title="Delete"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `nmi_api_settings` WHERE is_active = 1"));
                                $total_pages = ceil($total_records / $apis_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
