<?php include 'header.php'; ?>

<script>
function confirmDelete() {
    return confirm("Are you sure you want to delete this payment?");
}
</script>

<?php
$alert = "";

// Handle deletion (soft-delete by setting is_active = 0)
if (isset($_GET['payment_id'])) {
    $payment_id = (int) $_GET['payment_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `payment_fee` SET `is_active`='0' WHERE `id`='$payment_id'";
        if (mysqli_query($conn, $delete_query)) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                        <strong>Success!</strong> Payment deleted successfully.
                      </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button"></button>
                        <strong>Error!</strong> Failed to delete payment.
                      </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_payment_fee.php?payment_id=' . $payment_id . '&confirm=yes"; }</script>';
    }
}

// Pagination
$records_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $records_per_page;

$query = "SELECT * FROM `payment_fee` WHERE `is_active`=1 ORDER BY id DESC LIMIT $records_per_page OFFSET $offset";
$result = mysqli_query($conn, $query);
?>

<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h3 class="card-title">Manage Payments</h3>
                <a class="btn btn-outline-primary" href="add_payment_fee.php">Add New Payment</a>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Description</th>
                                <th>Amount</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_assoc($result)) {
                                $created_at = $row['created_at'];
                                // Convert to a timestamp
                                $timestamp = strtotime($created_at);
                                
                                // Format the combined date and time in US format (mm/dd/yyyy hh:mm:ss AM/PM)
                                $formatted_created_date = date('m/d/Y h:i:s A', $timestamp);
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['description']); ?></td>
                                    <td>$<?php echo htmlspecialchars($row['amount']); ?></td>
                                    <td><?php echo $formatted_created_date; ?></td>
                                    <td>
                                        <a href="edit_payment_fee.php?payment_id=<?php echo $row['id']; ?>"><i class="si si-note" title="Update Payment Fee"></i></a>
                                        <a href="manage_payment_fee.php?payment_id=<?php echo $row['id']; ?>"><i class="si si-close" title="Delete Payment"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <?php
                    $total_query = mysqli_query($conn, "SELECT COUNT(*) as total FROM `payment_fee` WHERE `is_active`=1");
                    $total_result = mysqli_fetch_assoc($total_query);
                    $total_pages = ceil($total_result['total'] / $records_per_page);
                    ?>

                    <nav>
                        <ul class="pagination">
                            <?php for ($i = 1; $i <= $total_pages; $i++): ?>
                                <li class="page-item <?php echo ($i == $current_page) ? 'active' : ''; ?>">
                                    <a class="page-link" href="?page=<?php echo $i; ?>"><?php echo $i; ?></a>
                                </li>
                            <?php endfor; ?>
                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
