<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this Account?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['account_id'])) {
    $customer_id = (int) $_GET['account_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `customer_accounts` SET `is_active`='0' WHERE `id`='$customer_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_pending_payments.php?account_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

$search = "";
$where = " (customer_accounts.is_active = 1 OR customer_accounts.is_active = 0) ";




// yasir's code
//////////////////////////////////////////////



if (isset($_GET['search']) && !empty(trim($_GET['search']))) {
    $search = mysqli_real_escape_string($conn, trim($_GET['search']));

    if (preg_match('/^\d{2}-\d{7}-\d{2}$/', $search)) {
        $where .= " AND customer_accounts.account_number = '$search'";
        $is_account_search = true;
    } else {
        $where .= " AND (
            customers.name LIKE '%$search%' OR 
            customers.address LIKE '%$search%' OR 
            customers.phone LIKE '%$search%' OR 
            customer_accounts.account_number LIKE '%$search%' OR 
            customer_accounts.balance LIKE '%$search%' OR 
            customer_accounts.last_update LIKE '%$search%'
        )";
        $is_account_search = false;
    }
} else {
    $is_account_search = false;
}




if (isset($_POST['create_account']) && !empty($_POST['account_number'])) {
    $account_number = mysqli_real_escape_string($conn, $_POST['account_number']);
    $created_at = date('Y-m-d H:i:s');

    $insert_customer = "INSERT INTO `customers` () VALUES ()";
    if (mysqli_query($conn, $insert_customer)) {
        $customer_id = mysqli_insert_id($conn);

        $insert_account = "INSERT INTO `customer_accounts`
                           (`account_number`, `old_account`, `last_amount`, `customer_id`, `last_update`, `is_active`, `balance`)
                           VALUES ('$account_number', '', 0, '$customer_id', '$created_at', 1, 0)";

        if (mysqli_query($conn, $insert_account)) {
            $alert = '<div class="alert alert-success" role="alert">
                        <strong>Account Created!</strong> New account <b>' . htmlspecialchars($account_number) . '</b> has been created. <b></b>
                      </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <strong>Error!</strong> Failed to create account. ' . mysqli_error($conn) . '
                      </div>';
        }
    } else {
        $alert = '<div class="alert alert-danger" role="alert">
                    <strong>Error!</strong> Failed to create blank customer. ' . mysqli_error($conn) . '
                  </div>';
    }
}



//////////////////////////////////////////////




// Pagination setup
$customers_per_page = 100;
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

// Fetch paginated customer accounts with search
  $query_customers = "SELECT customer_accounts.*, customers.name, customers.email as customer_email, customers.phone, customers.address as customer_address 
                    FROM customer_accounts 
                    LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                    WHERE $where
                    ORDER BY customers.name ASC 
                    LIMIT $offset, $customers_per_page";
$result_customers = mysqli_query($conn, $query_customers);

// Get total count for pagination (with search)
$total_count_query = "SELECT COUNT(*) as total 
                      FROM customer_accounts 
                      LEFT JOIN customers ON customers.id = customer_accounts.customer_id 
                      WHERE $where";
$total_count_result = mysqli_query($conn, $total_count_query);
$total_count_row = mysqli_fetch_assoc($total_count_result);
$total_records = $total_count_row['total'];
$total_pages = ceil($total_records / $customers_per_page);
?>
<style>
    .card-header i{
        display:block !important;
    }
</style>
<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-2">
                        <h3 class="card-title">Manage Accounts</h3>
                    </div>
                    <div class="col-md-6">
                        <form method="GET" class="">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="Search by name, phone, account number, balance, address etc." value="<?php echo htmlspecialchars($search); ?>">
                        <button type="submit" class="btn btn-primary">Search</button>
                    </div>
                    </form>

                    </div>
                    <div class="col-md-2">
                        <a class="btn btn-outline-primary float-end" href="upload_pending_payments.php" title="Add New Account">Upload Pending Payments</a>
                    </div>
                    <div class="col-md-2">
                        <button class="btn btn-secondary active btn-wave waves-effect waves-light" id="excel_file">Export to Excel</button>
                    </div>
                </div>
                <div class="row mt-4">
                    <div class="col-md-12">
                         <ul class="pagination">
                            <?php
                            $query_params = $_GET;
                            unset($query_params['page']); // Avoid duplicate page params

                            if ($current_page > 1) {
                                $query_params['page'] = $current_page - 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $query_params['page'] = $i;
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?' . http_build_query($query_params) . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                $query_params['page'] = $current_page + 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>

                
                <div class="table-responsive">
                    <table id="file-datatable" class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Phone</th>
                                <th>Account Number</th>
                                <th>Balance</th>
                                <th>Address</th>
                                <th>Last Update</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                        
                            if (mysqli_num_rows($result_customers) > 0) {
                                while ($row = mysqli_fetch_array($result_customers)) {
                                    $last_update = $row['last_update'];
                                    if (!empty($last_update) && strtotime($last_update) !== false) {
                                        $timestamp = strtotime($last_update);
                                        $formatted_last_update = date('m/d/Y h:i A', $timestamp);
                                    } else {
                                        $formatted_last_update = '';
                                    }
                            ?>
                                    <tr>
                                        <td><?php echo $counter++; ?></td>
                                        <td><?php echo htmlspecialchars($row['name']); ?></td>
                                        <td><?php echo htmlspecialchars($row['phone']);?></td>
                                        <td><?php echo htmlspecialchars($row['account_number']); ?></td>
                                        <td>$<?php echo number_format($row['balance'] < 0 ? 0 : htmlspecialchars($row['balance']), 2); ?></td>
                                        <td><?php echo htmlspecialchars($row['customer_address']); ?></td>
                                        <td><?php echo $formatted_last_update; ?></td>
                                        <td>
                                            <form action="../customer/login.php" method="POST">
                                                <input type="text" value="<?php echo htmlspecialchars($row['customer_id']); ?>" name="auto_login_user" hidden>
                                                <input type="text" value="<?php echo $_SESSION['admin_id'] ?>" name="transactions_admin_id" hidden>
                                                <input type="text" value="<?php echo $_SESSION['terminal_poi_device_id'] ?>" name="terminal_poi_device_id" hidden>
                                                <input type="submit" class="btn btn-primary-light rounded-pill btn-wave waves-effect waves-light" value="Login to Pay">
                                            </form>
                                        </td>
                                    </tr>
                            <?php
                                }
                            } else {
                                ?>
                                    <tr>
                                        <td colspan="7" class="text-center p-4">
                                            <?php if (!empty($search) && $is_account_search) { ?>
                                                  <div class="alert alert-danger mb-3">
                                                    No account found for <b><?php echo htmlspecialchars($search); ?></b>. 
                                                    Would you like to create one to proceed with payment?
                                                </div>
                                               <form method="POST" class="d-inline">
                                                    <input type="hidden" name="account_number" value="<?php echo htmlspecialchars($search); ?>">
                                                    <button type="submit" name="create_account" class="btn btn-primary">
                                                        Create Account
                                                    </button>
                                                </form>

                                            <?php } else { ?>
                                                <div class="alert alert-warning mb-3">
                                                    <strong>No results found.</strong> Try adjusting your search keywords.
                                                </div>
                                                <a href="manage_pending_payments.php" class="btn btn-outline-primary">
                                                    Reset Search
                                                </a>
                                            <?php } ?>
                                        </td>
                                    </tr>
                                <?php } ?>

                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="mt-3">
                        <ul class="pagination">
                            <?php
                            $query_params = $_GET;
                            unset($query_params['page']); // Avoid duplicate page params

                            if ($current_page > 1) {
                                $query_params['page'] = $current_page - 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                            }

                            for ($i = 1; $i <= $total_pages; $i++) {
                                if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                    $query_params['page'] = $i;
                                    $active_class = ($i == $current_page) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $active_class . '"><a class="page-link" href="?' . http_build_query($query_params) . '">' . $i . '</a></li>';
                                } elseif ($i == 2 || $i == $total_pages - 1) {
                                    echo '<li class="paginate_button page-item disabled"><a class="page-link">...</a></li>';
                                }
                            }

                            if ($current_page < $total_pages) {
                                $query_params['page'] = $current_page + 1;
                                echo '<li class="paginate_button page-item"><a class="page-link" href="?' . http_build_query($query_params) . '"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                            }
                            ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
document.getElementById('excel_file').addEventListener('click', function () {
    let table = document.getElementById('file-datatable');
    let excelData = [];

    for (let row of table.rows) {
        let rowData = [];
        for (let cell of row.cells) {
            rowData.push(cell.innerText.trim());
        }
        excelData.push(rowData);
    }

    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.aoa_to_sheet(excelData);
    XLSX.utils.book_append_sheet(wb, ws, "Accounts");

    let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

    function s2ab(s) {
        let buf = new ArrayBuffer(s.length);
        let view = new Uint8Array(buf);
        for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    let link = document.createElement('a');
    link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
    link.download = 'accounts_data.xlsx';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
});
</script>
