<?php 


include "header.php";

// Initialize variables
$success_message = '';
$error_messages = [];
$user = [];

// Get user ID from session
$user_id = $_SESSION['admin_id'];

// Process form submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Get form data
    $user_name = mysqli_real_escape_string($conn, $_POST['user_name']);
    $user_email = mysqli_real_escape_string($conn, $_POST['user_email']);
    $phone_number = mysqli_real_escape_string($conn, $_POST['phone_number']);
    $address = mysqli_real_escape_string($conn, $_POST['address']);
    $twitter = mysqli_real_escape_string($conn, $_POST['twitter']);
    $facebook = mysqli_real_escape_string($conn, $_POST['facebook']);
    $instagram = mysqli_real_escape_string($conn, $_POST['instagram']);
    $linkedin = mysqli_real_escape_string($conn, $_POST['linkedin']);
    $bio = mysqli_real_escape_string($conn, $_POST['bio']);

    // Handle file upload
    $user_logo = '';
    if (!empty($_FILES['user_logo']['name'])) {
        $target_dir = "assets/img/";
        $target_file = $target_dir . basename($_FILES['user_logo']['name']);
        $imageFileType = strtolower(pathinfo($target_file, PATHINFO_EXTENSION));
        
        // Check if image file is a actual image or fake image
        $check = getimagesize($_FILES['user_logo']['tmp_name']);
        if ($check !== false) {
            // Check file size (5MB max)
            if ($_FILES['user_logo']['size'] > 5000000) {
                $error_messages[] = "Sorry, your file is too large. Max 5MB allowed.";
            } elseif (!in_array($imageFileType, ['jpg', 'png', 'jpeg', 'gif'])) {
                $error_messages[] = "Sorry, only JPG, JPEG, PNG & GIF files are allowed.";
            } else {
                if (move_uploaded_file($_FILES['user_logo']['tmp_name'], $target_file)) {
                    $user_logo = basename($_FILES['user_logo']['name']);
                } else {
                    $error_messages[] = "Sorry, there was an error uploading your file.";
                }
            }
        } else {
            $error_messages[] = "File is not an image.";
        }
    }

    // If no errors, update database
    if (empty($error_messages)) {
        // Build the SQL query
        $sql = "UPDATE company_settings SET 
                user_name = '$user_name',
                user_email = '$user_email',
                phone_number = '$phone_number',
                address = '$address',
                twitter = '$twitter',
                facebook = '$facebook',
                instagram = '$instagram',
                linkedin = '$linkedin',
                bio = '$bio'";
        
        // Add logo to query if uploaded
        if (!empty($user_logo)) {
            $sql .= ", user_logo = '$user_logo'";
        }
        
        $sql .= " WHERE id = 1";
        
        // Execute query
        if (mysqli_query($conn, $sql)) {
            $success_message = "Profile updated successfully!";
            
            // Refresh user data
            $result = mysqli_query($conn, "SELECT * FROM admin_users WHERE id = $user_id");
            $user = mysqli_fetch_assoc($result);
            
            // Update session if needed
            $_SESSION['user_name'] = $user['user_name'];
            $_SESSION['user_email'] = $user['user_email'];
        } else {
            $error_messages[] = "Error updating profile: " . mysqli_error($conn);
        }
    }
}
    $sql = "SELECT * FROM company_settings WHERE id = 1";
    $result = mysqli_query($conn, $sql);
    $user = mysqli_fetch_assoc($result);

?>

<div class="container-fluid">
    <!-- Display success/error messages -->
    <?php if (!empty($success_message)): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <?php echo $success_message; ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($error_messages)): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <ul class="mb-0">
                <?php foreach ($error_messages as $error): ?>
                    <li><?php echo $error; ?></li>
                <?php endforeach; ?>
            </ul>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
    
    <!-- row -->
    <div class="row row-sm">
        <!-- Col -->
        <div class="col-lg-4">
            <div class="card mg-b-20">
                <div class="card-body">
                    <div class="ps-0">
                        <div class="main-profile-overview">
                            <div class="main-img-user profile-user" style="width:100%;height:100%">
                                <img alt="" src="assets/img/<?php echo $user['user_logo']; ?>">
                                <a href="JavaScript:void(0);" class="fas fa-camera profile-edit"></a>
                            </div>
                            <div class="d-flex justify-content-between mg-b-20">
                                <div>
                                    <h5 class="main-profile-name"><?php echo htmlspecialchars($user['user_name']); ?></h5>
                                    <p class="main-profile-name-text"><?php echo $user['user_email'] ?></p>
                                </div>
                            </div>
                            <h6>Bio</h6>
                            <div class="main-profile-bio"><?php echo htmlspecialchars($user['bio']); ?> <a class="text-primary" href="">More</a> </div>
                            <hr class="mg-y-30">
                            <label class="main-content-label fs-13 mg-b-20">Social</label>
                            <div class="main-profile-social-list">
                                <?php if (!empty($user['github'])): ?>
                                <div class="media">
                                    <div class="media-icon bg-primary-transparent text-primary">
                                        <i class="icon ion-logo-github"></i>
                                    </div>
                                    <div class="media-body">
                                        <span>Github</span> <a class="text-primary" href="<?php echo htmlspecialchars($user['github']); ?>"><?php echo htmlspecialchars($user['github']); ?></a>
                                    </div>
                                </div>
                                <?php endif; ?>
                                
                                <?php if (!empty($user['twitter'])): ?>
                                <div class="media">
                                    <div class="media-icon bg-info-transparent text-info">
                                        <i class="icon ion-logo-twitter"></i>
                                    </div>
                                    <div class="media-body">
                                        <span>Twitter</span> <a class="text-primary" href="<?php echo htmlspecialchars($user['twitter']); ?>"><?php echo htmlspecialchars($user['twitter']); ?></a>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($user['linkedin'])): ?>
                                <div class="media" bis_skin_checked="1">
                                    <div class="media-icon bg-info-transparent text-info flex-none" bis_skin_checked="1"> <i class="icon ion-logo-linkedin"></i> </div>
                                    <div class="media-body" bis_skin_checked="1"> <span>Linkedin</span> <a class="text-primary" href="<?php echo htmlspecialchars($user['linkedin']); ?>"><?php echo htmlspecialchars($user['linkedin']); ?></a> </div>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($user['facebook'])): ?>
                                <div class="media" bis_skin_checked="1">
                                    <div class="media-icon bg-info-transparent text-info flex-none" bis_skin_checked="1"> <i class="icon ion-logo-facebook"></i> </div>
                                    <div class="media-body" bis_skin_checked="1"> <span>Facebook</span> <a class="text-primary" href="<?php echo htmlspecialchars($user['facebook']); ?>"><?php echo htmlspecialchars($user['facebook']); ?></a> </div>
                                </div>
                                <?php endif; ?>
                                <?php if (!empty($user['instagram'])): ?>
                                <div class="media" bis_skin_checked="1">
                                    <div class="media-icon bg-info-transparent text-info flex-none" bis_skin_checked="1"> <i class="icon ion-logo-instagram"></i> </div>
                                    <div class="media-body" bis_skin_checked="1"> <span>instagram</span> <a class="text-primary" href="<?php echo htmlspecialchars($user['instagram']); ?>"><?php echo htmlspecialchars($user['instagram']); ?></a> </div>
                                </div>
                                <?php endif; ?>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="card mg-b-20" bis_skin_checked="1">
                <div class="card-body" bis_skin_checked="1">
                    <div class="main-content-label fs-13 mg-b-25" bis_skin_checked="1"> Conatct </div>
                    <div class="main-profile-contact-list" bis_skin_checked="1">
                        <div class="media" bis_skin_checked="1">
                            <div class="media-icon bg-primary-transparent text-primary" bis_skin_checked="1"> <i class="icon ion-md-phone-portrait"></i> </div>
                            <div class="media-body" bis_skin_checked="1"> <span>Mobile</span>
                                <div bis_skin_checked="1"><?php echo $user['phone_number']; ?></div>
                            </div>
                        </div>
                        <div class="media" bis_skin_checked="1">
                            <div class="media-icon bg-success-transparent text-success" bis_skin_checked="1"> <i class="icon ion-ios-mail"></i> </div>
                            <div class="media-body" bis_skin_checked="1"> <span>Email</span>
                                <div bis_skin_checked="1"><?php echo $user['user_email']; ?></div>
                            </div>
                        </div>
                        <div class="media" bis_skin_checked="1">
                            <div class="media-icon bg-info-transparent text-info" bis_skin_checked="1"> <i class="icon ion-md-locate"></i> </div>
                            <div class="media-body" bis_skin_checked="1"> <span>Current Address</span>
                                <div bis_skin_checked="1"> <?php echo $user['address']; ?> </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Col -->
        
        <!-- Col -->
        <div class="col-lg-8">
            <div class="card">
                <div class="card-body">
                    <div class="mb-4 main-content-label">Personal Information</div>
                    <form class="form-horizontal" method="POST" action="" enctype="multipart/form-data">
                        <div class="mb-4 main-content-label">Name</div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Company Name</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="user_name" class="form-control" placeholder="Company Name" value="<?php echo htmlspecialchars($user['user_name']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="input-file" class="form-label">Company Logo</label>
                                </div>
                                <div class="col-md-9">
                                    <input class="form-control" type="file" name="user_logo" id="input-file" accept="image/*">
                                    <?php if (!empty($user['user_logo'])): ?>
                                        <small class="text-muted">Current logo: <?php echo htmlspecialchars($user['user_logo']); ?></small>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <div class="mb-4 main-content-label">Contact Info</div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Email<i>(required)</i></label>
                                </div>
                                <div class="col-md-9">
                                    <input type="email" name="user_email" class="form-control" placeholder="Email" value="<?php echo htmlspecialchars($user['user_email']); ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Phone</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="phone_number" class="form-control" placeholder="phone number" value="<?php echo htmlspecialchars($user['phone_number']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Address</label>
                                </div>
                                <div class="col-md-9">
                                    <textarea name="address" class="form-control" rows="2" placeholder="Address"><?php echo htmlspecialchars($user['address']); ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="mb-4 main-content-label">Social Info</div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Twitter</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="twitter" class="form-control" placeholder="twitter" value="<?php echo htmlspecialchars($user['twitter']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Facebook</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="facebook" class="form-control" placeholder="facebook" value="<?php echo htmlspecialchars($user['facebook']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Instagram</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="instagram" class="form-control" placeholder="instagram" value="<?php echo htmlspecialchars($user['instagram']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">LinkedIn</label>
                                </div>
                                <div class="col-md-9">
                                    <input type="text" name="linkedin" class="form-control" placeholder="linkedin" value="<?php echo htmlspecialchars($user['linkedin']); ?>">
                                </div>
                            </div>
                        </div>

                        <div class="mb-4 main-content-label">About Yourself</div>
                        <div class="form-group">
                            <div class="row">
                                <div class="col-md-3">
                                    <label class="form-label">Biographical Info</label>
                                </div>
                                <div class="col-md-9">
                                    <textarea name="bio" class="form-control" rows="4"><?php echo htmlspecialchars($user['bio']); ?></textarea>
                                </div>
                            </div>
                        </div>

                        <div class="card-footer" style="text-align: end;">
                            <button type="submit" class="btn btn-primary waves-effect waves-light">Update Profile</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <!-- /Col -->
    </div>
    <!-- row closed -->
</div>
<?php include "footer.php"; ?>