<?php
include('header.php');
$alert = "";

// Get ID from URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    echo "Invalid ID!";
    exit;
}
$id = intval($_GET['id']);

// Fetch existing data
$query = "SELECT * FROM nmi_api_settings WHERE id = $id";
$result = mysqli_query($conn, $query);
$data = mysqli_fetch_assoc($result);

// If form submitted, update
if (isset($_POST['name'])) {
    $name = mysqli_real_escape_string($conn, $_POST['name']);
    $url = mysqli_real_escape_string($conn, $_POST['url']);
    $api_key = mysqli_real_escape_string($conn, $_POST['api_key']);

    $update_query = "UPDATE nmi_api_settings SET name='$name', url='$url', api_key='$api_key' WHERE id = $id";

    if (mysqli_query($conn, $update_query)) {
        $alert = '<div class="alert alert-success" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Success!</strong> API settings updated successfully.
        </div>';
        // Refresh data
        $query = "SELECT * FROM nmi_api_settings WHERE id = $id";
        $result = mysqli_query($conn, $query);
        $data = mysqli_fetch_assoc($result);
    } else {
        $alert = '<div class="alert alert-danger" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Error!</strong> Failed to update. Please try again.
        </div>';
    }
}
?>

<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="main-content-label mg-b-5">
                    Update NMI API Settings<br><br>
                </div>
                <?php echo $alert; ?>

                <div class="">
                    <form method="POST">
                        <div class="row row-xs formgroup-wrapper">
                            <div class="col-md-6 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">Name</label>
                                    <input class="form-control" name="name" type="text" required value="<?php echo htmlspecialchars($data['name']); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">URL</label>
                                    <input class="form-control" name="url" type="text" required value="<?php echo htmlspecialchars($data['url']); ?>">
                                </div>
                            </div>
                            <div class="col-md-6 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">API Key</label>
                                    <input class="form-control" name="api_key" type="text" required value="<?php echo htmlspecialchars($data['api_key']); ?>">
                                </div>
                            </div>

                            <div class="col-md-12"> <hr> </div>
                            <div class="col-md-12">
                                <input class="form-control btn btn-primary pd-x-30 mg-e-5 mg-t-5" type="submit" value="Update">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
<?php include 'footer.php'; ?>
