<?php
ini_set('display_errors', '1');
ini_set('display_startup_errors', '1');
error_reporting(E_ALL);

require '../composer/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

include 'header.php';

$alert = "";

// Handle file upload and process Excel
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['excel_file'])) {
    try {
        if ($_FILES['excel_file']['error'] == UPLOAD_ERR_OK) {
            $fileTmpPath = $_FILES['excel_file']['tmp_name'];
            $fileName = $_FILES['excel_file']['name'];
            $fileExtension = pathinfo($fileName, PATHINFO_EXTENSION);
            $allowedExtensions = ['xlsx', 'xls'];

            if (!in_array($fileExtension, $allowedExtensions)) {
                $alert = '<div class="alert alert-warning" role="alert">
                            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                                <span aria-hidden="true">×</span>
                            </button>
                            <strong>Invalid file type!</strong> Please upload a .xlsx or .xls file.
                        </div>';
            } else {
                $spreadsheet = IOFactory::load($fileTmpPath);
                $sheet = $spreadsheet->getSheet(0);
                $data = $sheet->toArray();

                if (!empty($data)) {
                    
                   foreach ($data as $pending_payment) {
                        
                        $Account_Number =   $pending_payment[0];
                        $Contact_Name   =   $pending_payment[1];
                        $Service_Address=   $pending_payment[2];
                        $Status  =   $pending_payment[3];
                        $Billing_Cycle_Code =   $pending_payment[4];
                        $Landlord =  $pending_payment[5];
                        $Cut_Off =  $pending_payment[6];
                        $Balance =  $pending_payment[7];
                        $Pending_Activity =  $pending_payment[8];
                        $Pending_Connect =   $pending_payment[9];
                        $Parcel_Number =  $pending_payment[10];
                        $Tax_Parcel_Number =   $pending_payment[11];
                        $Account_Class     =   $pending_payment[12];
                        $Disconnect_Date     =   $pending_payment[13];
                        $Start_Date     =   $pending_payment[14];
                        $SSN_Last_Four     =   $pending_payment[15];
                        $Email_Address     =   $pending_payment[16];
                        $HANDICAP     =   $pending_payment[17];
                        $Old_Account     =   $pending_payment[18];
                        $Permit_No     =   $pending_payment[19];
                        $Polycart_Fee_Paid     =   $pending_payment[20];
                        $currnt_date =date('Y-m-d H:i:s');
                        
                       $Contact_Name =  str_replace("'","",$Contact_Name);
                       $Service_Address =  str_replace("'","",$Service_Address);
                       $Contact_Name =  str_replace('"',"",$Contact_Name);
                       $Service_Address =  str_replace('"',"",$Service_Address);

                        if(empty($Email_Address)){
                        $Email_Address = $Account_Number.'@nativesolutionsun.com';
                        }
                       $select_customer_accounts =  "SELECT * FROM `customer_accounts` WHERE `account_number`='$Account_Number'";
                       $result_customer_accounts = mysqli_query($conn, $select_customer_accounts);

                        if (mysqli_num_rows($result_customer_accounts) > 0) {
                          // output data of each row
                          while($row = mysqli_fetch_assoc($result_customer_accounts)) {
                                
                                $sql_customer_id = $row['customer_id'];
                                
                              $upadte_customer_accounts = "UPDATE `customer_accounts` SET `old_account`='$Old_Account',`balance`='$Balance',`last_update`='$currnt_date' WHERE `account_number`='$Account_Number'";
                              mysqli_query($conn, $upadte_customer_accounts);
                              
                              $update_customers = "UPDATE `customers` SET `status` = '$Status' WHERE id = '$sql_customer_id'";
                              mysqli_query($conn, $update_customers);
                              

                          }
                        } else {
                            
                          $user_password = base64_encode($Email_Address);
                          $insert_customers = "INSERT INTO `customers`(`name`, `email`, `address`, `created_at`, `last_update`, `user_password`, `status`) VALUES ('$Contact_Name','$Email_Address','$Service_Address','$currnt_date','$currnt_date','$user_password','$Status')";
                          mysqli_query($conn, $insert_customers);
                          
                          $customers_id = mysqli_insert_id($conn);
                          $insert_customer_accounts = "INSERT INTO `customer_accounts`(`account_number`, `balance`, `customer_id`, `last_update`,`old_account`) VALUES ('$Account_Number','$Balance','$customers_id','$currnt_date','$Old_Account')";
                            mysqli_query($conn, $insert_customer_accounts);

                          
                          }



                    }

                    $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Success!</strong> File processed and data saved successfully.
                    </div>';
                } else {
                    $alert = '<div class="alert alert-warning" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Warning!</strong> No data found in the Excel file.
                    </div>';
                }
            }
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                    <span aria-hidden="true">×</span>
                </button>
                <strong>Error!</strong> File upload failed. Error Code: ' . $_FILES['excel_file']['error'] . '
            </div>';
        }
    } catch (Exception $e) {
        $alert = '<div class="alert alert-danger" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Exception!</strong> ' . $e->getMessage() . '
        </div>';
    }
}
?>

<form method="post" enctype="multipart/form-data">
  <div class="row row-sm">
    <div class="col-lg-12 col-md-12">
      <div class="card">
        <div class="card-body">
          <div class="main-content-label mg-b-5">Upload Excel File For More Workorder</div>
          <?= $alert ?>
          <div class="pd-30 pd-sm-40 bg-gray-100 mt-4">
            <div class="row row-xs align-items-center mg-b-20">
              <div class="col-md-5">
                <label for="excel_file">Choose Excel file:</label>
                <div class="custom-file">
                  <input class="custom-file-input" id="customFile" name="excel_file" type="file" accept=".xlsx, .xls" required>
                  <label class="custom-file-label" for="customFile">Choose file</label>
                </div>
              </div>
            </div>
            <button type="submit" class="btn btn-primary btn-upload" name="submit">Upload Excel</button>
            <a href="assets/Bulk_upload_file_Ex.csv" class="btn btn-info btn-download pd-x-30 text-decoration-none" download style="color:#f1f1f2">Download Work Order Example File</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</form>

<?php include 'footer.php'; ?>
