<?php
include "header.php";
include "company_info.php";


$id = (int)$_GET['id'];

$query = "
    SELECT t.*,
           c.name AS customer_name, c.email, c.phone,
           ca.account_number
    FROM transcations t
    LEFT JOIN customers c ON c.id = t.user_id
    LEFT JOIN customer_accounts ca ON ca.customer_id = c.id
    WHERE t.id = $id
    LIMIT 1
";
$result = mysqli_query($conn, $query);

if (!$result || mysqli_num_rows($result) == 0) {
    echo "<div class='alert alert-warning'>Transaction not found.</div>";
    include "footer.php";
    exit;
}

$txn = mysqli_fetch_assoc($result);
// echo "hahaha".$txn['transaction_id'];
$transactionDateTime = $txn['date'] . ' ' . $txn['time'];
$formattedDate = date('m/d/Y h:i A', strtotime($transactionDateTime));

$phone_display = '';
if (!empty($txn['phone'])) {
    $phone_display = preg_replace("/(\d{3})(\d{3})(\d{4})/", "($1) $2-$3", $txn['phone']);
}

$payment_type_des = '';
if ($txn['type'] == 'nmi') $payment_type_des = 'Card';
elseif ($txn['type'] == 'green') $payment_type_des = 'eCheck';
elseif ($txn['type'] == 'cash') $payment_type_des = 'Cash';

$status_label = $txn['status'];
if ($txn['status'] == 'Approved' || $txn['status'] == 'SUCCESS') {
    $status_label = "<span class='badge bg-success'>Approved</span>";
} elseif ($txn['status'] == 'Pending') {
    $status_label = "<span class='badge bg-warning text-dark'>Pending</span>";
} 
 elseif ($txn['status'] == 'Partial Refund') {
    $status_label = "<span class='badge bg-warning text-dark'>Partial Refund</span>";
} 
elseif ($txn['status'] == 'Refunded') {
    $status_label = "<span class='badge bg-danger'>Refunded</span>";
}
else {
    $status_label = "<span class='badge bg-danger'>Declined</span>";
}


$tyler_message = '';

if (isset($_POST['update_tyler_export']) && isset($_POST['transaction_id'])) {
    $transaction_id = (int)$_POST['transaction_id'];
    $password = $_POST['tyler_password'] ?? '';

    if ($password !== '9999') {
        $tyler_message = "<div class='alert alert-warning mt-3'>Incorrect password</div>";
    } else {
        $query = "UPDATE transcations SET tyler_export = 0 WHERE transaction_id = '$transaction_id'";
        $result = mysqli_query($conn, $query);

        if ($result) {
            $tyler_message = "<div class='alert alert-success mt-3'>Transaction marked as Tyler Exported!</div>"
;
        } else {
            $tyler_message = "<div class='alert alert-danger mt-3'>Error updating tyler exported!</div>";
        }
    }
}

?>


<div class="container" style="margin-top: 5rem !important;">
  <div class="row">
      <?php if ($tyler_message != ''): ?>
    <div class="mt-2"><?= $tyler_message ?></div>
<?php endif; ?>
    <div class="col-lg-12">
      <div class="card">
        <div class="card-body">
          <h3 class="card-title mb-4">Transaction Detail</h3>
                <div class="mt-4">
            <div class="btn-group">
                  <button class="btn btn-danger dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-expanded="false">
                    Refund
                  </button>
                  <div class="dropdown-menu p-3" style="min-width: 250px;">
                    <form action="nmi_refund.php" method="POST">
                     <input type="hidden" name="transaction_id" value="<?= htmlspecialchars($txn['transaction_id']) ?>">
                      <div class="mb-2">
                        <label for="refund_amount" class="form-label">Refund Amount ($)</label>
                        <input type="number" step="0.01" class="form-control" id="refund_amount" name="refund_amount"
                               value="<?= number_format(str_replace('USD', '', $txn['amount']), 2) ?>"
                               max="<?= number_format(str_replace('USD', '', $txn['amount']), 2) ?>" required>
                        <small class="text-muted">Max: $<?= number_format(str_replace('USD', '', $txn['amount']), 2) ?></small>
                      </div>
                
                      <button type="submit" class="btn btn-danger w-100">Confirm Refund</button>
                    </form>
                  </div>
                </div>
                  <a href="download_invoice.php?id=<?= $txn['id'] ?>&transcation_id=<?= $txn['transaction_id'] ?>" 
                     target="_blank" class="btn btn-secondary">Print Receipt</a>
                  <!--<a href="transactions.php" class="btn btn-outline-secondary">Back</a>-->
                  <form method="POST" id="tylerExportForm">
                    <input type="hidden" name="transaction_id" value="<?= htmlspecialchars($txn['transaction_id']) ?>">
                    <input type="hidden" name="tyler_password" id="tyler_password">
                    <button type="submit" name="update_tyler_export" class="btn btn-primary mt-3" style="background: #ff5e00;border: none;">Resend to Tyler</button>
                </form>
                </div>
               <br>
          <div class="row">
            <div class="col-md-6 mb-3">
              <table class="table table-bordered">
                <tbody>
                  <tr><th style="width: 40%;">Transaction ID</th><td><?= htmlspecialchars($txn['transaction_id']) ?></td></tr>
                  <tr><th>Date / Time</th><td><?= $formattedDate ?></td></tr>
                  <tr><th>Status</th><td><?= $status_label ?></td></tr>
                  <tr><th>Payment Type</th><td><?= $payment_type_des ?></td></tr>
                  <tr><th>Method</th><td><?= htmlspecialchars($txn['inperson_online_check']) ?></td></tr>
                  <tr><th>Type</th><td><?= htmlspecialchars($txn['payment_type'] ? str_replace('_', ' ', ucwords($txn['payment_type'])) : $txn['payment_type']) ?></td></tr>
                </tbody>
              </table>
            </div>

            <div class="col-md-6 mb-3">
              <table class="table table-bordered">
                <tbody>
                  <tr><th style="width: 40%;">Amount</th><td>$<?= number_format(str_replace('USD', '', $txn['amount']), 2) ?></td></tr>
                  <tr><th>Fee</th><td>$<?= number_format($txn['fee_amount'], 2) ?></td></tr>
                  <tr><th>Total</th>
                    <td><b style="color:green;">$<?= number_format(str_replace('USD', '', $txn['amount']), 2) ?></b></td>
                  </tr>
                  <tr><th>Card</th><td><?= htmlspecialchars($txn['card']) ?></td></tr>
                </tbody>
              </table>
            </div>
          </div>

          <div class="row mt-3">
            <div class="col-md-12">
              <table class="table table-bordered">
                <tbody>
                  <tr><th style="width: 20%;">Customer Name</th><td><?= htmlspecialchars($txn['customer_name']) ?></td></tr>
                  <tr><th>Email</th><td><?= htmlspecialchars($txn['email']) ?></td></tr>
                  <tr><th>Phone</th><td><?= $phone_display ?></td></tr>
                  <tr><th>Account #</th><td><?= htmlspecialchars($txn['account_number']) ?></td></tr>
                </tbody>
              </table>
            </div>
          </div>

        </div>
      </div>
    </div>
  </div>
</div>

<script type="text/javascript">
    document.querySelector('form').addEventListener('submit', function(event) {
        event.preventDefault(); 
        
        const refundAmount = document.querySelector('#refund_amount').value;
        const transactionId = document.querySelector('input[name="transaction_id"]').value;
        
        const password = prompt("Enter password to confirm refund of $" + refundAmount + ":");
        
        if (password === null) {
            // User clicked cancel
            return;
        }
        
        if (password === '') {
            alert('Password cannot be empty.');
            return;
        }
        
        if (confirm("Are you sure you want to refund $" + refundAmount + "?")) {
            const formData = new FormData();
            formData.append('transaction_id', transactionId);
            formData.append('refund_amount', refundAmount);
            formData.append('refund_password', password);
            
            fetch('nmi_refund.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                alert(data); 
                location.reload(); 
            })
            .catch(error => {
                alert('Error: ' + error);
            });
        }
    });
    
    
    document.querySelector('#tylerExportForm').addEventListener('submit', function(event) {
    const password = prompt("Enter password to mark this transaction as Tyler Exported:");

    if (password === null) { 
        event.preventDefault();
        return;
    }

    if (password === '') {
        alert('Password cannot be empty.');
        event.preventDefault();
        return;
    }

    document.querySelector('#tyler_password').value = password;
});

</script>


<?php include "footer.php"; ?>
