<?php
require('fpdf/fpdf.php');

class PDF_Javascript extends FPDF
{
    protected $javascript;
    protected $n_js;

    function IncludeJS($script, $isUTF8 = false)
    {
        if (!$isUTF8)
            $script = utf8_encode($script);
        $this->javascript = $script;
    }

    function _putjavascript()
    {
        $this->_newobj();
        $this->_out('<<');
        $this->_out('/Names [(EmbeddedJS) ' . ($this->n_js + 1) . ' 0 R]');
        $this->_out('>>');
        $this->_out('endobj');
        $this->_newobj();
        $this->n_js = $this->n;
        $this->_out('<<');
        $this->_out('/S /JavaScript');
        $this->_out('/JS ' . $this->_textstring($this->javascript));
        $this->_out('>>');
        $this->_out('endobj');
    }

    function _putresources()
    {
        parent::_putresources();
        if (!empty($this->javascript)) {
            $this->_putjavascript();
        }
    }

    function _putcatalog()
    {
        parent::_putcatalog();
        if (!empty($this->javascript)) {
            $this->_out('/Names <</JavaScript ' . $this->n_js . ' 0 R>>');
        }
    }
}
