<?php 
include 'header.php';
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this Account?");
    }
</script>

<?php
$alert = "";
if (isset($_GET['account_id'])) {
    $customer_id = (int) $_GET['account_id'];

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        $delete_query = "UPDATE `customer_accounts` SET `is_active`='0' WHERE `id`='$customer_id'";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> Customer deleted successfully.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Error!</strong> Failed to delete the customer.
                    </div>';
        }
    } else {
        echo '<script>if(confirmDelete()) { window.location.href = "manage_accounts.php?account_id=' . $customer_id . '&confirm=yes"; }</script>';
    }
}

$customers_per_page = 25;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $customers_per_page;

$query_customers = "SELECT customer_accounts.*,customers.name,customers.card_number FROM `customer_accounts` left join customers on customers.id = customer_accounts.customer_id where customer_accounts.is_active =1 AND customer_id='$login_user_id'  ORDER BY customer_accounts.id DESC LIMIT $customers_per_page OFFSET $offset";
$result_customers = mysqli_query($conn, $query_customers);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-8">
                        <h3 class="card-title">Manage Accounts</h3>
                    </div>
                    <div class="col-md-4">
                        <a class="btn btn-outline-primary float-end" href="add_account.php" title="Add New Account">Add New Account</a>
                    </div>
                </div>
            </div>

            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table class="table table-bordered text-nowrap border-bottom">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Card Number</th>
                                <th>Account Number</th>
                                <th>Last Ammount</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;
                            while ($row = mysqli_fetch_array($result_customers)) {
                            ?>
                                <tr>
                                    <td><?php echo $counter++; ?></td>
                                    <td><?php echo htmlspecialchars($row['name']); ?></td>
                                    <td><?php echo htmlspecialchars($row['card_number']); ?></td>
                                    <td><?php echo htmlspecialchars($row['account_number']); ?></td>
                                    <td><?php echo htmlspecialchars($row['last_ammount']); ?></td>
                                    <td>
                                        <a href="update_account.php?account_id=<?php echo $row['id']; ?>"><i class="si si-note" title="Update Account"></i></a>
                                        <a href="manage_accounts.php?account_id=<?php echo $row['id']; ?>"><i class="si si-close" title="Delete Account"></i></a>
                                    </td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `customer_accounts` where is_active =1 AND customer_id='$login_user_id'"));
                                $total_pages = ceil($total_records / $customers_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>
