<?php 
include "header.php"; 

$transcations_per_page = 500; 
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $transcations_per_page;

$start_date = isset($_GET['start_date']) ? mysqli_real_escape_string($conn, $_GET['start_date']) : '';
$end_date = isset($_GET['end_date']) ? mysqli_real_escape_string($conn, $_GET['end_date']) : '';
$filter_sql = '';

$filter_payment_type = isset($_GET['filter_payment_type']) ? mysqli_real_escape_string($conn, $_GET['filter_payment_type']) : '';
$filter_category = isset($_GET['filter_category']) ? mysqli_real_escape_string($conn, $_GET['filter_category']) : '';

if (!empty($start_date) && !empty($end_date)) {
    $filter_sql = " AND `date` BETWEEN '$start_date' AND '$end_date'";
}

if (empty($start_date) && empty($end_date)) {
    $start_date = date('Y-m-d', strtotime('-12 months'));
    $end_date = date('Y-m-d'); // today's date
    $filter_sql = " AND `date` BETWEEN '$start_date' AND '$end_date'";

}

if (!empty($filter_payment_type)) {
    $filter_sql .= " AND `type` = '$filter_payment_type'";
}


if (!empty($filter_category)) {
    $filter_sql .= " AND t.custom_payment_category = '$filter_category'";
}


$search_account = isset($_GET['search_account']) ? trim(mysqli_real_escape_string($conn, $_GET['search_account'])) : '';

if (!empty($search_account)) {
    $search_account_clean = str_replace([' ', '-'], '', $search_account);

    $filter_sql .= " AND (
        REPLACE(REPLACE(t.transaction_id, '-', ''), ' ', '') LIKE '%$search_account_clean%'
        OR REPLACE(REPLACE(t.card, '-', ''), ' ', '') LIKE '%$search_account_clean%'
    )";
}


// Count total records
$count_query = "
SELECT COUNT(*) AS total 
FROM `transcations` t
LEFT JOIN `payments_category` pc ON t.custom_payment_category = pc.id
WHERE t.user_id = '$login_user_id' $filter_sql";

$total_records_result = mysqli_query($conn, $count_query);
$total_records_row = mysqli_fetch_assoc($total_records_result);
$total_records = $total_records_row['total'];
$total_pages = ceil($total_records / $transcations_per_page);

// Fetch paginated transactions
$sql_transcations = "
SELECT t.*, pc.description AS payment_category_description 
FROM `transcations` t
LEFT JOIN `payments_category` pc ON t.custom_payment_category = pc.id
WHERE t.user_id = '$login_user_id' $filter_sql
ORDER BY t.id DESC
LIMIT $offset, $transcations_per_page";

$result_transcations = mysqli_query($conn, $sql_transcations);
?>

<style>
    /* Target input[type="date"] and its calendar picker in dark mode */
        .dark-theme input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(1); /* This inverts the icon color */
        }
        
        /* Ensure other styling for the form-control stays */
        .dark-theme .form-control {
            color: #dde3ea;
            background-color: var(--dark-theme);
            border-color: rgba(222, 228, 236, 0.07) !important;
        }
        
        
        .card-header i{
            display:block !important;
        }
        
</style>

<div class="container" >
  <div class="row">
    <div class="col-lg-12">
      <div class="card ">
        <div class="card-body">
            <form method="GET">
                    <div class="row mb-3" bis_skin_checked="1" style="align-items: center;">
                      <div class="col-md-2 mt-2"><h5>Manage Transaction  <br> <span style="font-size: 12px;"> <?php echo $start_date ?> - <?php echo $end_date; ?></span></h5></div>
                      <div class="col-md-3 mt-2" bis_skin_checked="1">
                        <div class="input-group mb-2" bis_skin_checked="1">
                            <div class="row" bis_skin_checked="1">
                          <div class="input-group col-md-6" bis_skin_checked="1">
                               <b>From:</b>
                              <br>
                            <div class="input-group" bis_skin_checked="1">
                                <input class="form-control" name="start_date" id="start_date" value="<?php echo isset($start_date) ? $start_date : ''; ?>" placeholder="MM/DD/YYYY" type="date">
                            </div>
                          </div>
                          <div class="input-group col-md-6" bis_skin_checked="1">
                               <b>To:</b>
                              <br>
                              
                            <div class="input-group" bis_skin_checked="1">
                                <input class="form-control" name="end_date" id="end_date" value="<?php echo isset($end_date) ? $end_date : ''; ?>" placeholder="MM/DD/YYYY" type="date">
                            </div>
                          </div>
                          </div>
                        </div>
                      </div>
                    <div class="col-md-2 mt-2">
                          <b>Transaction ID:</b><br>
                          <input type="text" class="form-control" name="search_account"  value="<?= $_GET['search_account'] ?? ''; ?>" placeholder="Search Transaction ID">
                    </div>
                      <div class="col-md-2 mt-2">
                        <b>Category:</b><br>
                        <?php
                        $categories_result = mysqli_query($conn, "SELECT * FROM payments_category");
                        $selected_category = $_GET['filter_category'] ?? '';
                        ?>
                        <select class="form-control" name="filter_category">
                            <option value="">All</option>
                            <?php
                            while ($cat = mysqli_fetch_assoc($categories_result)) {
                                $selected = ($selected_category == $cat['id']) ? 'selected' : '';
                                echo "<option value=\"{$cat['id']}\" $selected>{$cat['description']} <b> {$cat['gl_code']}</b></option>";
                            }
                            ?>
                        </select>
                    </div>
                        <div class="col-md-1 mt-2">
                        <b>Method:</b><br>
                            <?php $selected_payment = $_GET['filter_payment_type'] ?? ''; ?>
                        <select class="form-control" name="filter_payment_type">
                            <option value="">All</option>
                            <option value="nmi" <?php echo ($selected_payment == 'nmi') ? 'selected' : ''; ?>>Card</option>
                            <option value="cash" <?php echo ($selected_payment == 'cash') ? 'selected' : ''; ?>>Cash</option>
                        </select>
                        </div>
                      
                       <div class="col-md-1 mt-2" bis_skin_checked="1">
                          &nbsp; 
                        <br>
                        <button class="btn btn-primary buttons-excel buttons-html5 w-100" type="submit"><span>Apply</span></button>
                    </div>
                      <div class="col-md-1 mt-2" bis_skin_checked="1" style="padding-left:0 !important;">
                          &nbsp; 
                        <br>
                     <button class="btn btn-secondary active btn-wave waves-effect waves-light" id="excel_file">Export to Excel</button>    
                    </div>
                    </div>
            </form>
                    <div class="row">
                        <div class="col-md-12">
                             <ul class="pagination">
                                <?php
                                    $query_string = '';
                                    if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                                    if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                                    if (!empty($filter_payment_type)) $query_string .= '&search_filter=&filter_payment_type=' . urlencode($filter_payment_type);
                                    if (!empty($filter_category)) $query_string .= '&filter_category=' . urlencode($filter_category);
                                    if (!empty($search_account)) $query_string .= '&search_account=' . urlencode($search_account);

                                    // Previous Button
                                    if ($current_page > 1) {
                                        echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                                </a></li>';
                                    }
                                
                                    for ($i = 1; $i <= $total_pages; $i++) {
                                        if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                            $class = ($current_page == $i) ? 'active' : '';
                                            echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                                        } elseif ($i == 2 || $i == $total_pages - 1) {
                                            echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                                        }
                                    }
                                
                                    // Next Button
                                    if ($current_page < $total_pages) {
                                        echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                                    }
                                ?>
                    </ul>
                        </div>
                    </div>
                    <div class="table-responsive" bis_skin_checked="1">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer" role="grid" aria-describedby="file-datatable_info">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Date and Time</th>
                                <!--<th>Time</th>-->
                                <th>Transaction id</th>
                                <th>Card</th>
                                <!--<th>Name on Card</th>-->
                                <th>Vehicle License Number</th>
                                <th>Payment Category/Type</th>
                                
                                
                                <th>Payment Amount</th>
                                <th>Fee</th>
                                <th>Payment Type</th>
                                <th>Total Payment</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $t_total_amount = 0;
                                $t_total_tax = 0;
                                $t_total_amount_tax = 0;
                                $counter = $offset+1;
                                if (mysqli_num_rows($result_transcations) > 0) {
                                  // output data of each row
                                  while($row_transcations = mysqli_fetch_assoc($result_transcations)) {
                                    $row_id = $row_transcations['id'];
                                    $custom_customer_name = $row_transcations['custom_customer_name'];
                                    $custom_license_number = $row_transcations['custom_license_number'];
                                    $custom_payment_category = $row_transcations['custom_payment_category'];
                                    
                                    $transaction_id  = $row_transcations['transaction_id'];
                                    $amount  = (float)$row_transcations['amount'];
                                    $card  = $row_transcations['card'];
                                    $date  = $row_transcations['date'];
                                    $fee_amount  = $row_transcations['fee_amount'];
                                    $amount_without_fee  = $row_transcations['amount_without_fee'];
                                    $time  = $row_transcations['time'];
                                    $cashier_payment_type = $row_transcations['type'];
                                    if($cashier_payment_type==='nmi'){
                                        $cashier_payment_type = "Card";
                                    }
                                     if($cashier_payment_type==='cash'){
                                        $cashier_payment_type = "Cash";
                                    }
                                    // Combine date and time to form a complete datetime string
                                    $dateTimeString = $date . ' ' . $time;
                                    
                                    // Convert the combined string to a timestamp
                                    $timestamp = strtotime($dateTimeString);
                                    
                                    // Format date in US format (mm/dd/yyyy)
                                    $formatted_date = date('m/d/Y', $timestamp);
                                    
                                    // Format time in 12-hour format (hh:mm:ss AM/PM)
                                    $formatted_time = date('h:i A', $timestamp);
                                    
                                    $payment_category_description = $row_transcations['payment_category_description'];
                                    $t_total_amount = $t_total_amount + $amount_without_fee;
                                    $t_total_tax = $t_total_tax + $fee_amount ;
                                    $t_total_amount_tax = $t_total_amount_tax + $amount;
                                    
                            ?>
                                <tr>
                                <td><?php echo $counter; ?></td>
                                <td><?php echo htmlspecialchars($customer_name) . '<br><b>' . htmlspecialchars($custom_customer_name) . '</b>'; ?></td>
                                <td><?php echo $formatted_date . '<br>'. $formatted_time; ?></td>
                                <!--<td><?php echo $formatted_time; ?></td>-->
                                <td><?php echo $transaction_id; ?></td>
                                <td><?php echo $card; ?></td>
                                <td><?php echo $custom_license_number ?></td>
                                <td><?php echo $payment_category_description ?></td>
                                <td>$<?php echo $amount_without_fee; ?></td>
                                <td>$<?php echo $fee_amount; ?></td>
                                <td><?php echo $cashier_payment_type; ?></td>
                                <td>$<?php echo $amount ? number_format($amount, 2) : '0.00'; ?></td>
                                <td><?php echo $row_transcations['status']; ?></td>
                                <td>
                                    <a target="_blank" href="download_invoice.php?id=<?php echo $row_id ; ?>&transcation_id=<?php echo $transaction_id; ?>" title="Print">
                                          <i class="fas fa-print" style="color:red;"></i>
                                    </a>
                                </td>
                                </tr>
                                <?php 
                                    $counter++;
                                  }
                                  
                                }
                                ?>  
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><b>Total </b></td>
                                    <td><b>$<?php echo number_format($t_total_amount,2);?></b></td>
                                    <td><b>$<?php echo number_format($t_total_tax,2);?></b></td>
                                    <td><b>$<?php echo number_format($t_total_amount_tax,2);?></b></td>
                                   
                                    <td></td>
                                </tr
                        </tbody>
                    </table>
                    <!-- Pagination -->
                    <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($filter_payment_type)) $query_string .= '&search_filter=&filter_payment_type=' . urlencode($filter_payment_type);
                        if (!empty($filter_category)) $query_string .= '&filter_category=' . urlencode($filter_category);
                        if (!empty($search_account)) $query_string .= '&search_account=' . urlencode($search_account);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>

                </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php 
include "footer_above_section.php"; 
include "footer.php"; 
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.4/xlsx.full.min.js"></script>
<script>
document.getElementById('excel_file').addEventListener('click', function () {
    let table = document.getElementById('file-datatable');
    let excelData = [];

    for (let row of table.rows) {
        let rowData = [];
        for (let cell of row.cells) {
            rowData.push(cell.innerText.trim());
        }
        excelData.push(rowData);
    }

    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.aoa_to_sheet(excelData);
    XLSX.utils.book_append_sheet(wb, ws, "Accounts");

    let wbout = XLSX.write(wb, { bookType: 'xlsx', type: 'binary' });

    function s2ab(s) {
        let buf = new ArrayBuffer(s.length);
        let view = new Uint8Array(buf);
        for (let i = 0; i < s.length; i++) view[i] = s.charCodeAt(i) & 0xFF;
        return buf;
    }

    let link = document.createElement('a');
    link.href = URL.createObjectURL(new Blob([s2ab(wbout)], { type: 'application/octet-stream' }));
    link.download = 'accounts_data.xlsx';
    document.body.appendChild(link);
    link.click();
    document.body.removeChild(link);
});
</script>
