<?php
include "../connection.php";
require 'src/PHPMailer.php';
require 'src/SMTP.php';
require 'src/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

function email_notification($notification_type, $email_subject, $email_body ,$team_id,$created_by_email) {
    global $conn; // Make sure to use the global $conn variable

    $email_array = [];
    $email_array[] = $created_by_email;

    if ($notification_type == "Workorder") {
         $query_select_users = "SELECT * FROM `dbo.aspnetusers` WHERE is_notifiable_workorder = '1' AND Team ='$team_id' ";
    } elseif ($notification_type == "Facility_booking") {
        $query_select_users = "SELECT * FROM `dbo.aspnetusers` WHERE is_notifiable_facility_booking = '1'";
    } else {
        echo "Invalid notification type";
        return;
    }

    $result_users = mysqli_query($conn, $query_select_users);

    if ($result_users === false) {
        echo "Error executing query: " . mysqli_error($conn);
        return;
    }

    if (mysqli_num_rows($result_users) > 0) {
        while ($row = mysqli_fetch_assoc($result_users)) {
            $email = $row['Email'];
            $email_array[] = $email;
        }
    } else {
        echo "No users found";
        return;
    }
    // print_r($email_array);
    // Send the email to the users
    if (!empty($email_array)) {
        if (sendEmail($email_array, $email_subject, $email_body)) {
            // echo 'Email sent successfully';
        } else {
            // echo 'Failed to send email';
        }
    } else {
        echo "No users to notify";
    }
}

function sendEmail($to, $subject, $body) {
    $mail = new PHPMailer(true); // Passing `true` enables exceptions

    try {
        // Server settings
        $mail->isSMTP(); // Set mailer to use SMTP
        $mail->Host = 'govproprocessing.net/'; // Specify main and backup SMTP servers
        $mail->SMTPAuth = true; // Enable SMTP authentication
        $mail->Username = 'govproprocessing@govproprocessing.net'; // SMTP username
        $mail->Password = 'govproprocessing@govproprocessing.net'; // SMTP password
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS; // Enable SSL encryption
        $mail->Port = 465; // TCP port to connect to (use 587 for TLS)

        // Sender
        $mail->setFrom('govproprocessing@govproprocessing.net', 'North Central Solid Waste Authority');

        // Content
        $mail->isHTML(true); // Set email format to HTML
        $mail->Subject = $subject;
        $mail->Body = $body;

        foreach ($to as $recipient) {
            // Add a recipient
            $mail->clearAddresses(); // Clear any previous recipients
            $mail->addAddress($recipient);
            
            // Send email
            $mail->send();
        }
        
        return true;
    } catch (Exception $e) {
        echo "Mailer Error: " . $mail->ErrorInfo;
        return false;
    }
}



?>
