<?php
include('header.php');
include('./admin/functions.php');
$alert = "";

if (isset($_POST['submit'])) {
    $account_number = preg_replace('/\D/', '', $_POST['account_number']);
    $cvv = preg_replace('/\D/', '', $_POST['cvv']);
    if (strlen($cvv) !== 3) {
        die("CVV must be exactly 3 digits.");
    }

    $expiry_input = $_POST['expiry_date'];

    if (!preg_match('/^\d{2}\/\d{2}$/', $expiry_input)) {
        die("Invalid expiry format. Use MM/YY.");
    }

    // Encrypt
    $check_existing = mysqli_query($conn, "SELECT `encrypted` FROM `saved_cards_endc` WHERE `user_id` = '$login_user_id'");
    $duplicate_found = false;

while ($row = mysqli_fetch_assoc($check_existing)) {
    $decrypted = decrypt_card($row['encrypted']);
    if ($decrypted['account_number'] === $account_number) {
        $duplicate_found = true;
        break;
    }
}

if ($duplicate_found) {
    $alert = '<div class="alert alert-warning" role="alert">
        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
            <span aria-hidden="true">×</span>
        </button>
        <strong>Note:</strong> This card number is already saved.
    </div>';
} else {
    // remove duplication
    $encrypted = encrypt_card($account_number, $cvv, $expiry_input);
    $first_name = mysqli_real_escape_string($conn, $_POST['first_name']);
    $last_name = mysqli_real_escape_string($conn, $_POST['last_name']);

    // Insert encrypted value
    $insert_query = "INSERT INTO `saved_cards_endc`(`user_id`, `encrypted`, `first_name`, `last_name`) VALUES ('$login_user_id','$encrypted', '$first_name', '$last_name')";
    if (mysqli_query($conn, $insert_query)) {
        $alert = '<div class="alert alert-success" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Success!</strong> Card has been added successfully.
        </div>';
    } else {
        $alert = '<div class="alert alert-danger" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Error!</strong> Failed to add Card. Please try again.
        </div>';
    }
}

}
?>


<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="main-content-label mg-b-5">
                    ADD Card<br><br>
                </div>
                <?php echo $alert; ?>

                <div class="">
                    <form method="POST">
                        <div class="row row-xs formgroup-wrapper">
                             <div class="col-md-4 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">First Name</label>
                                     <input class="form-control" type="text" name="first_name" id="first_name" maxlength="19" required
                                        placeholder="Enter your first name">
                                </div>
                            </div>
                            
                             <div class="col-md-4 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">Last Name</label>
                                     <input class="form-control" type="text" name="last_name" id="last_name" maxlength="19" required
                                        placeholder="Enter your last name">
                                </div>
                            </div>
                            
                            
                            <div class="col-md-4 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">Card Number</label>
                                     <input class="form-control" type="text" name="account_number" id="account_number" maxlength="19" required
                                        placeholder="1234-5678-9012-3456" pattern="\d{4}-\d{4}-\d{4}-\d{4}">
                                </div>
                            </div>
                            <div class="col-md-4 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">CVV</label>
                                   
                                   <input class="form-control" type="text" name="cvv" id="cvv" maxlength="3" required pattern="\d{3}" required
                                        placeholder="Enter your CVV">
                                </div>
                            </div>
                            <div class="col-md-4 mg-t-20">
                                <div class="main-form-group">
                                    <label class="form-label">Expiry</label>
                                           <input class="form-control" type="text" name="expiry_date" id="expiry_date" maxlength="5" required placeholder="MM/YY"
                                        pattern="\d{2}/\d{2}">
                                </div>
                            </div>

                            <div class="col-md-12"> <hr> </div>
                            <div class="col-md-12">
                                <input class="form-control btn btn-primary pd-x-30 mg-e-5 mg-t-5" name="submit" type="submit" value="Add Card">
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

    <script>
    const input = document.getElementById('account_number');

    input.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, ''); // remove non-digits
        value = value.slice(0, 16); // max 16 digits

        let formatted = '';
        for (let i = 0; i < value.length; i++) {
            if (i > 0 && i % 4 === 0) formatted += '-';
            formatted += value[i];
        }

        e.target.value = formatted;
    });

    function stripDashes() {
        const input = document.getElementById('account_number');
        input.value = input.value.replace(/-/g, ''); // remove dashes before submitting
    }

    const expiryInput = document.getElementById('expiry_date');
    expiryInput.addEventListener('input', function(e) {
        let value = e.target.value.replace(/\D/g, '').slice(0, 4);
        if (value.length >= 3) {
            value = value.slice(0, 2) + '/' + value.slice(2);
        }
        e.target.value = value;
    });

    function stripDashes() {
        cardInput.value = cardInput.value.replace(/-/g, '');
        expiryInput.value = expiryInput.value.replace(/\D/g, '').slice(0, 4); // Only MMYY digits
    }

    document.querySelector('form').addEventListener('submit', function(e) {
        const expiry = document.getElementById('expiry_date').value;
        const parts = expiry.split('/');

        if (parts.length !== 2) {
            alert("Invalid expiry format. Use MM/YY.");
            e.preventDefault();
            return;
        }

        const month = parseInt(parts[0], 10);
        const year = parseInt('20' + parts[1], 10);

        if (isNaN(month) || isNaN(year) || month < 1 || month > 12) {
            alert("Invalid expiry month or year.");
            e.preventDefault();
            return;
        }

        const now = new Date();
        const currentMonth = now.getMonth() + 1;
        const currentYear = now.getFullYear();

        if (year < currentYear || (year === currentYear && month < currentMonth)) {
            alert("Expiry date cannot be in the past.");
            e.preventDefault();
        }
    });
    
    document.getElementsByName('cvv')[0].addEventListener('input', function(e) {
    e.target.value = e.target.value.replace(/\D/g, '').slice(0, 3);
    });

    </script>

<?php include 'footer.php'; ?>
