<?php
ob_start();

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require('connection.php');
require('fpdf/fpdf.php');

// if (!isset($_GET['transcation_id']) || empty($_GET['transcation_id'])) {
//     exit("Transaction ID is missing.");
// }

$transaction_id = $_GET['transcation_id'];
$transaction_db_id = $_GET['id'];

 $query = "SELECT * FROM transcations WHERE id = '$transaction_db_id' OR transaction_id = '$transaction_db_id' ";
$result = mysqli_query($conn, $query);
$transaction = mysqli_fetch_assoc($result);

if (!$transaction) {
    exit("Transaction not found.");
}


$user_id = $transaction['user_id'];


$sql_us = "SELECT * FROM customer_accounts where customer_id = '$user_id' ";
$result_us = mysqli_query($conn, $sql_us);
$account_number = "";
if (mysqli_num_rows($result_us) > 0) {
  // output data of each row
  while($row_us = mysqli_fetch_assoc($result_us)) {
      
      $account_number = $row_us['account_number'];
  }
}
$final_transaction_id = $transaction['transaction_id'];
$subtotal = number_format($transaction['amount_without_fee'], 2);
$fee = number_format($transaction['fee_amount'], 2);
$total = $transaction['amount'];
$date = $transaction['date'];
$date = date("m/d/Y", strtotime($date));
$time = $transaction['time'];
$time = date("h:i A", strtotime($time));
$card = $transaction['card'];
$status = strtoupper($transaction['status']);
if($status=='APPROVED'){
    $status = 'PAID';
}
$customer = $transaction['custom_customer_name'];
$license = $transaction['custom_license_number'];
$category = $transaction['custom_payment_category'];
$payment_type = $transaction['type'];
if($payment_type=='nmi'){
    $payment_type = 'Card';
}
if($payment_type=='green'){
    $payment_type = 'eCheck';
}
if($payment_type=='cash'){
    $payment_type = 'Cash';
}
    
$sql_c = "SELECT * FROM payments_category where id = '$category'";
$result_c = mysqli_query($conn, $sql_c);

if (mysqli_num_rows($result_c) > 0) {
  // output data of each row
  while($row_c = mysqli_fetch_assoc($result_c)) {
    $category = $row_c['description'];
  }
}


// Calculate auto height using dummy PDF
$dummy = new FPDF('P', 'mm', array(72, 1300)); // tall page to simulate content height

$dummy->SetAutoPageBreak(false);

$dummy->SetMargins(4, 4, 4);
$dummy->AddPage();
$dummy->SetFont('Arial', '', 8);

$dummy->Image('gov_logo.png', 20, 4, 30);
$dummy->Ln(30);

$dummy->SetFont('Arial', 'B', 10);
$dummy->Cell(0, 6, 'Payment Receipt', 0, 1, 'C');
$dummy->Ln(2);

$field_width = 26;
$value_width = 72 - 4 - 4 - $field_width;
$lineHeight = 6;

$dummy->SetFont('Arial', 'B', 9);
$dummy->Cell($field_width, 6, 'Details', 1, 0);
$dummy->Cell($value_width, 6, '', 1, 1);

$dummy->SetFont('Arial', '', 9);
$dummy->Cell($field_width, 6, 'Transaction ID', 1, 0);
$dummy->Cell($value_width, 6, $final_transaction_id, 1, 1);

$dummy->Cell($field_width, 6, 'Date', 1, 0);
$dummy->Cell($value_width, 6, "$date $time", 1, 1);

$x = $dummy->GetX();
$y = $dummy->GetY();
$lines = ceil($dummy->GetStringWidth($status) / $value_width);
$height = $lines * $lineHeight;
$dummy->MultiCell($field_width, $height, 'Status', 1);
$dummy->SetXY($x + $field_width, $y);
$dummy->MultiCell($value_width, $lineHeight, $status, 1);

$dummy->Cell($field_width, 6, 'Customer', 1, 0);
$dummy->MultiCell($value_width, 6, $customer, 1);

$dummy->Cell($field_width, 6, 'License #', 1, 0);
$dummy->Cell($value_width, 6, $license, 1, 1);

$dummy->Cell($field_width, 6, 'Category', 1, 0);
$dummy->Cell($value_width, 6, $category, 1, 1);

$dummy->Cell($field_width, 6, 'Subtotal', 1, 0);
$dummy->Cell($value_width, 6, "$$subtotal", 1, 1);

$dummy->Cell($field_width, 6, 'Fee', 1, 0);
$dummy->Cell($value_width, 6, "$$fee", 1, 1);

$dummy->Cell($field_width, 6, 'Total', 1, 0);
$dummy->Cell($value_width, 6, "$$total", 1, 1);

$dummy->Cell($field_width, 6, 'Card', 1, 0);
$dummy->MultiCell($value_width, 6, $card, 1);

$dummy->Cell($field_width, 6, 'Payment Type', 1, 0);
$dummy->MultiCell($value_width, 6, $payment_type, 1);

$dummy->Ln(5);
$dummy->SetFont('Arial', 'I', 6);
$dummy->Cell(0, 5, "Thank you for your payment!", 0, 1, 'C');

$auto_height = $dummy->GetY() + 12; // adds 12mm bottom padding





$pdf = new FPDF('P', 'mm', array(72, $auto_height));
$pdf->SetAutoPageBreak(false);



$pdf->AddPage();

$pdf->Image('gov_logo.png', 20, 4, 30); 
$pdf->Ln(25); 

$pdf->SetMargins(4, 4, 4);
$pdf->SetFont('Arial', '', 9);

$pdf->SetFont('Arial', 'B', 11);
$pdf->Cell(52, 2, 'Payment Receipt', 0, 1, 'C');

$pdf->Ln(2); 
$pdf->SetFont('Arial', '', 8);
$pdf->Cell(62, 3, 'North Central Solid Waste Authority', 0, 1, 'C');
$pdf->Ln(2);

// Define fixed column widths
$field_width = 28;
$value_width = 72 - 4 - 4 - $field_width; // page width - left & right margins - field width

// Table Header
$pdf->SetFont('Arial', 'B', 8);
$pdf->Cell($field_width, 6, 'Field', 1, 0, 'C');
$pdf->Cell($value_width, 6, 'Value', 1, 1, 'C');

// Table Data
$pdf->SetFont('Arial', '', 8);

$pdf->Cell($field_width, 6, 'Transaction ID', 1, 0);
$pdf->Cell($value_width, 6, $final_transaction_id, 1, 1);

$pdf->Cell($field_width, 6, 'Confirmation #', 1, 0);
$pdf->Cell($value_width, 6, $final_transaction_id, 1, 1);
$pdf->Cell($field_width, 6, 'Account #', 1, 0);
$pdf->Cell($value_width, 6, $account_number, 1, 1);


$pdf->Cell($field_width, 6, 'Date', 1, 0);
$pdf->Cell($value_width, 6, "$date $time", 1, 1);

// Save current position
// Save current position
$x = $pdf->GetX();
$y = $pdf->GetY();

$lineHeight = 6;

// Calculate how many lines the status will take
$pdf->SetFont('Arial', '', 8);
$lines = ceil($pdf->GetStringWidth($status) / $value_width);
$height = $lines * $lineHeight;

// Draw the field name ("Status")
$pdf->MultiCell($field_width, $height, 'Status', 1, 'L');

// Reset X/Y to draw the value next to it
$pdf->SetXY($x + $field_width, $y);

// Draw the value with wrapping
$pdf->MultiCell($value_width, $lineHeight, $status, 1, 'L');



$pdf->Cell($field_width, 6, 'Customer', 1, 0);
$pdf->MultiCell($value_width, 6, $customer, 1);

$pdf->Cell($field_width, 6, 'License #', 1, 0);
$pdf->Cell($value_width, 6, $license, 1, 1);

$pdf->Cell($field_width, 6, 'Category', 1, 0);
$pdf->Cell($value_width, 6, $category, 1, 1);

$pdf->Cell($field_width, 6, 'Subtotal', 1, 0);
$pdf->Cell($value_width, 6, "$$subtotal", 1, 1);
$total = str_replace("USD","",$total);
$pdf->Cell($field_width, 6, 'Fee', 1, 0);
$pdf->Cell($value_width, 6, "$$fee", 1, 1);

$pdf->Cell($field_width, 6, 'Total', 1, 0);
$pdf->Cell($value_width, 6, "$$total", 1, 1);

$pdf->Cell($field_width, 6, 'Card', 1, 0);
$pdf->MultiCell($value_width, 6, $card, 1);

$pdf->Cell($field_width, 6, 'Payment Type', 1, 0);
$pdf->MultiCell($value_width, 6, ucfirst($payment_type), 1);

$pdf->Ln(3);
$pdf->SetFont('Arial', 'I', 6);
$pdf->Cell(0, 5, "Thank you for your payment!", 0, 1, 'C');




ob_end_clean();
$actual_height = $pdf->GetY() + 10; // add a bottom margin
$pdf->PageSizes[0] = array(72, $actual_height); // set final page height

$pdf->Output('I', "Invoice_$final_transaction_id.pdf");

?>
