<?php
require_once '../Green.php';
use Green\CheckGateway as Gateway;

include('../../connection.php');

$selected_accounts = $_POST['multiple_accounts'] ?? [];
$child_amounts     = $_POST['child_payment_amount'] ?? [];
$accounts_with_payments = [];

if (!empty($selected_accounts)) {
    $id_list = implode(",", array_map('intval', $selected_accounts));
    $query = "
        SELECT 
            customer_accounts.id AS account_id,
            customer_accounts.account_number,
            customers.id AS customer_id,
            customers.name,
            customers.email,
            customers.address
        FROM customer_accounts
        LEFT JOIN customers ON customers.id = customer_accounts.customer_id
        WHERE customer_accounts.customer_id IN ($id_list)
    ";
    $result = mysqli_query($conn, $query);
    while ($row = mysqli_fetch_assoc($result)) {
        $payment_amount = isset($child_amounts[$row['account_id']]) ? floatval($child_amounts[$row['account_id']]) : 0;
        $accounts_with_payments[] = [
            'account_id'     => $row['account_id'],
            'customer_id'    => $row['customer_id'],
            'payment_amount' => $payment_amount,
            'account_number' => $row['account_number'],
        ];
    }
}

// Common POST values
$only_fee_amount = str_replace(",", "", $_POST['only_fee_amount'] ?? 0);
$user_id         = $_POST['user_id'];
$firstname       = $_POST['firstname'];
$lastname        = $_POST['lastname'];
$email           = $_POST['email'];

$echeck_routing_number = $_POST['echeck_routing_number'];
$echeck_account_number = $_POST['echeck_account_number'];
$echeck_bank_name      = $_POST['echeck_bank_name'];

$address1 = $_POST['echeck_address'];
$city     = $_POST['echeck_city'];
$state    = $_POST['echeck_state'];
$zip      = $_POST['echeck_zip'];
$phone    = $_POST['echeck_phone'];

mysqli_query($conn,"UPDATE customers SET phone='$phone' WHERE id = '$user_id'");

include('auth.php');

// --- 1. Calculate total amount for single API call ---
$total_amount_api = 0;
foreach ($accounts_with_payments as $account) {
    $payment_amount = $account['payment_amount'];
    $fee_amount     = ($account['customer_id'] == $user_id) ? floatval($only_fee_amount) : 0;
    $total_amount_api += $payment_amount + $fee_amount;
}

// --- 2. Make ONE eCheck API call ---
$gateway = new Gateway($ClientID, $ApiPassword);
$name    = "$firstname $lastname";
$memo    = 'Payment NMCSA!';
$date    = date("m/d/Y");
$date_11 = date("Y-m-d");
$time    = date("H:i:s");

$result = $gateway->singleCheck(
    $name,
    $email,
    $phone,
    '',
    $address1,
    '',
    $city,
    $state,
    $zip,
    'US',
    $echeck_routing_number,
    $echeck_account_number,
    $echeck_bank_name,
    $memo,
    $total_amount_api,
    $date
);

if ($result && $result['Result'] == '0') {
    // Success
    $transaction_id = $result['Check_ID'];
    $status = "Pending";

    foreach ($accounts_with_payments as $account) {
        $account_id             = $account['account_id'];
        $customer_id            = $account['customer_id'];
        $account_payment_amount = $account['payment_amount'];

        if ($account_payment_amount <= 0) continue;

        $fee_amount = ($customer_id == $user_id) ? floatval($only_fee_amount) : 0;
        $total_amount_account = $account_payment_amount + $fee_amount;

        $amount_without_fee_formatted = number_format($account_payment_amount, 2, '.', '');
        $fee_amount_formatted         = number_format($fee_amount, 2, '.', '');
        $amount_to_store_formatted    = number_format($total_amount_account, 2, '.', '');

        $sql = "INSERT INTO `transcations`(`transaction_id`,`status`,`amount`,`fee_amount`,`amount_without_fee`,`card`,`date`,`time`,`user_id`,`user_type`,`date_time`,`type`,`inperson_online_check`) VALUES ('$transaction_id','$status','$amount_to_store_formatted','$fee_amount_formatted','$amount_without_fee_formatted','$transaction_id','$date_11','$time','$customer_id','customer','$date_11 $time','green','{$_POST['inperson_online_check']}')";
        mysqli_query($conn, $sql);
    }

    echo "<script>location.replace('../../payment_confirmation_green.php?success=success&transaction_id=$transaction_id');</script>";
} else {
    // Failure
    $error = $result['ResultDescription'] ?? 'Gateway Error';
    $transaction_id = $result['Check_ID'] ?? '';

    $sql = "INSERT INTO `transcations`(`transaction_id`,`status`,`amount`,`fee_amount`,`amount_without_fee`,`card`,`date`,`time`,`user_id`,`user_type`,`date_time`,`type`,`error_description`,`inperson_online_check`) VALUES ('$transaction_id','Error','$total_amount_api','$only_fee_amount','$total_amount_api','$transaction_id','$date_11','$time','$user_id','customer','$date_11 $time','green','$error','{$_POST['inperson_online_check']}')";
    mysqli_query($conn, $sql);

    echo "<script>location.replace('../../payment_confirmation_green.php?error=error&error_description=$error');</script>";
}
?>
