<?php 
include 'header.php';
include('./admin/functions.php');
?>

<script>
    function confirmDelete() {
        return confirm("Are you sure you want to delete this card?");
    }
</script>

<?php


//echo "hahaha".$login_user_id;
$alert = "";
if (isset($_GET['card_id'])) {
    $card_id = (int) $_GET['card_id']; // Cast to integer for safety

    if (isset($_GET['confirm']) && $_GET['confirm'] == 'yes') {
        // Perform the deletion
        $delete_query = "DELETE FROM `saved_cards_endc` WHERE id = $card_id";
        $result = mysqli_query($conn, $delete_query);

        if ($result) {
            $alert = '<div class="alert alert-success" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Well done!</strong> You have successfully deleted the card.
                    </div>';
        } else {
            $alert = '<div class="alert alert-danger mg-b-0" role="alert">
                        <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                            <span aria-hidden="true">×</span>
                        </button>
                        <strong>Oh snap!</strong> Failed to delete the card. Please try again.
                    </div>';
        }
    } else {
        // Show confirmation prompt
        echo '<script>if(confirmDelete()) { window.location.href = "manage_cards.php?card_id=' . $card_id . '&confirm=yes"; }</script>';
    }
}

$cards_per_page = 100;
$current_page = max(1, isset($_GET['page']) ? $_GET['page'] : 1);
$offset = ($current_page - 1) * $cards_per_page;

//echo "vvvvv".$login_user_id;
// Corrected JOIN with pagination
$query_cards = "SELECT * FROM `saved_cards_endc` WHERE `user_id` = '$login_user_id'
                ORDER BY id DESC 
                LIMIT $cards_per_page OFFSET $offset";

$result_cards = mysqli_query($conn, $query_cards);
?>

<div class="row row-sm">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="row">
                    <div class="col-md-10">
                        <h3 class="card-title">Manage Cards</h3>
                    </div>
                    <div class="col-md-2">
                        <a class="btn btn-outline-primary ms-auto float-end" href="add_cards.php" data-bs-placement="top" data-bs-toggle="tooltip" title="Add New Card">Add New Card</a>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <?php echo $alert; ?>
                <div class="table-responsive">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>First Name</th>
                                <th>Last Name</th>
                                <th>Card Number</th>
                                <th>CVV</th>
                                <th>Expiration Date</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $counter = $offset + 1;

                        if (mysqli_num_rows($result_cards) > 0) {
                            while ($row_cards = mysqli_fetch_array($result_cards)) {
                                $first_name = $row_cards['first_name'];
                                $last_name = $row_cards['last_name'];
                                $decrypted = decrypt_card($row_cards['encrypted']);
                                $expiry = $decrypted['expiry'];
                                $account = $decrypted['account_number'];
                                $cvv = $decrypted['cvv'];
                                
                                
                                // echo "Expiry date: " . $expiry;
                                // echo "Account Number: " . $account;
                                // echo "CVV: " . $cvv;
                                
                        ?>
                                <tr>
                                    <td><?php echo $counter; ?></td>
                                    <td><?php echo $first_name; ?></td>
                                    <td><?php echo $last_name; ?></td>
                                    <td><?php echo str_repeat('*', 12) . substr($account, -4); ?></td>
                                    <td><?php echo str_repeat('*', strlen($cvv)); ?></td>
                                    <td><?php echo substr($expiry, 0, 2) . '/' . str_repeat('*', 2); ?></td>

                                    <td>
                                        <a href="manage_cards.php?card_id=<?php echo $row_cards['id']; ?>"><i class="si si-close" title="Delete card"></i></a>
                                    </td>
                                </tr>
                        <?php 
                                $counter++;
                            }
                        } else {
                            echo '<tr><td colspan="7" class="text-center text-muted">No cards saved yet.</td></tr>';
                        }
                            ?>
                          
                        </tbody>
                    </table>

                    <!-- Pagination -->
                    <div class="col-sm-12 col-md-6">
                        <div class="dataTables_paginate paging_simple_numbers">
                            <ul class="pagination">
                                <?php
                                $total_records = mysqli_num_rows(mysqli_query($conn, "SELECT * FROM `saved_cards_endc`"));
                                $total_pages = ceil($total_records / $cards_per_page);

                                for ($i = 1; $i <= $total_pages; $i++) {
                                    $class = ($current_page == $i) ? 'active' : '';
                                    echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . '" class="page-link">' . $i . '</a></li>';
                                }
                                ?>
                            </ul>
                        </div>
                    </div>

                
                
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'footer.php'; ?>

