<?php
// mandrill_email.php

function sendMandrillEmail($to, $email_body, $subject, $from_name) {
    
    // ⭐ 1. BASIC EMAIL VALIDATION
    if (!filter_var($to, FILTER_VALIDATE_EMAIL)) {
        return false; // Invalid email format
    }

    // ⭐ 2. BLOCK SPECIFIC DOMAIN
    if (stripos($to, '@nativesolutionsun.com') !== false) {
        return false; // Block this domain
    }
    
    $api_key = "md-GMQbhDFVVA8Ks5Hkzd8tlw";  // Replace with your Mandrill API key
    $from_email = "admin@govproprocessing.net";
    
    // Add the email template design with dynamic content
    $email_content = "
    <!DOCTYPE html PUBLIC '-//W3C//DTD XHTML 1.0 Transitional//EN' 'http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd'>
    <html xmlns='http://www.w3.org/1999/xhtml' xmlns:v='urn:schemas-microsoft-com:vml' xmlns:o='urn:schemas-microsoft-com:office:office'>
    <head>
        <meta charset='UTF-8'>
        <meta http-equiv='X-UA-Compatible' content='IE=edge'>
        <meta name='viewport' content='width=device-width, initial-scale=1'>
        <title>$subject</title>
        <style type='text/css'>
            body { background-color:#f4f4f4; font-family:Arial, sans-serif; margin:0; padding:0; }
            .templateContainer { max-width:600px; margin:0 auto; background-color:#ffffff; border-radius:8px; box-shadow:0 2px 10px rgba(0, 0, 0, 0.1); overflow:hidden; }
            .header { background-color:#364c62; padding:20px; text-align:center; }
            .header img { max-width:150px; height:auto; }
            .body { padding:20px; color:#333333; }
            .body h1 { color:#222222; font-size:24px; margin-bottom:10px; }
            .body p { line-height:1.6; margin:10px 0; }
            .button { display:inline-block; background-color:#364c62; color:#ffffff; padding:12px 20px; text-decoration:none; border-radius:5px; margin-top:20px; }
            .footer { background-color:#f4f4f4; padding:15px; text-align:center; font-size:12px; color:#656565; }
        </style>
    </head>
    <body>
        <center>
            <table align='center' border='0' cellpadding='0' cellspacing='0' height='100%' width='100%' id='bodyTable'>
                <tr>
                    <td align='center' valign='top' id='bodyCell'>
                        <div class='templateContainer'>
                            <div class='header'>
                                <img src='https://govproprocessing.net/ncswa/admin/assets/img/northcentralso_logo.png' alt='North Central Solid Waste Authority Logo'>
                                <p style='color: white; font-weight: bold; font-size: 16px;'>North Central Solid Waste Authority</p>
                            </div>
                            <div class='body'>
                                <h1>$subject</h1>
                                <p align='left'>Hi there,</p>
                                <p align='left'>$email_body</p>
                                <p align='left'>If you did not request this, please ignore this email.</p>
                                <p align='left'>Thank you!</p>
                            </div>
                            <div class='footer'>
                                <em>Copyright &copy; 2025 <a href='https://govproprocessing.net/ncswa' style='color: #364c62; font-weight: bold; font-size: 12px; text-decoration: none;'>North Central Solid Waste Authority</a>, All rights reserved.</em><br>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
        </center>
    </body>
    </html>
    ";
    
    $post_data = array(
        'key' => $api_key,
        'message' => array(
            'from_email' => $from_email,
            'from_name' => $from_name,
            'subject' => $subject,
            'html' => $email_content,
            'to' => array(
                array(
                    'email' => $to,
                    'name' => 'User',
                    'type' => 'to'
                )
            )
        )
    );

    $ch = curl_init();
    curl_setopt_array($ch, array(
        CURLOPT_URL => 'https://mandrillapp.com/api/1.0/messages/send.json',
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_CUSTOMREQUEST => 'POST',
        CURLOPT_POSTFIELDS => json_encode($post_data),
        CURLOPT_HTTPHEADER => array(
            'Content-Type: application/json'
        )
    ));

    $response = curl_exec($ch);
    curl_close($ch);

    // Check if the email was sent successfully
    $response_data = json_decode($response, true);
    if (isset($response_data[0]['status']) && $response_data[0]['status'] == 'sent') {
        return true;
    } else {
        return false;
    }
}
?>
