<?php 
include "header.php"; 

$transcations_per_page = 500; 
$current_page = max(1, isset($_GET['page']) ? (int)$_GET['page'] : 1);
$offset = ($current_page - 1) * $transcations_per_page;

$start_date = isset($_GET['start_date']) ? mysqli_real_escape_string($conn, $_GET['start_date']) : '';
$end_date = isset($_GET['end_date']) ? mysqli_real_escape_string($conn, $_GET['end_date']) : '';
$filter_sql = '';

if (!empty($start_date) && !empty($end_date)) {
    $filter_sql = " AND `date` BETWEEN '$start_date' AND '$end_date'";
}

if (empty($start_date) && empty($end_date)) {
    $start_date = date('Y-m-d', strtotime('-12 months'));
    $end_date = date('Y-m-d'); // today's date
    $filter_sql = " AND `date` BETWEEN '$start_date' AND '$end_date'";

}

$search_txn = isset($_GET['search_txn']) ? trim(mysqli_real_escape_string($conn, $_GET['search_txn'])) : '';

if (!empty($search_txn)) {
    $search_txn_clean = str_replace([' ', '-'], '', $search_txn);
    $filter_sql .= " AND REPLACE(REPLACE(transaction_id, '-', ''), ' ', '') LIKE '%$search_txn_clean%'";
}

// Count total records
$count_query = "SELECT COUNT(*) AS total FROM `transcations` WHERE `user_id`='$login_user_id' $filter_sql";
$total_records_result = mysqli_query($conn, $count_query);
$total_records_row = mysqli_fetch_assoc($total_records_result);
$total_records = $total_records_row['total'];
$total_pages = ceil($total_records / $transcations_per_page);

// Fetch paginated transactions
 $sql_transcations = "SELECT * FROM `transcations` 
                    WHERE `user_id`='$login_user_id' $filter_sql 
                    ORDER BY `id` DESC 
                    LIMIT $offset, $transcations_per_page";
$result_transcations = mysqli_query($conn, $sql_transcations);

$last_inserted_transcation_db_id = mysqli_insert_id($conn);

?>

<style>
    /* Target input[type="date"] and its calendar picker in dark mode */
        .dark-theme input[type="date"]::-webkit-calendar-picker-indicator {
            filter: invert(1); /* This inverts the icon color */
        }
        
        /* Ensure other styling for the form-control stays */
        .dark-theme .form-control {
            color: #dde3ea;
            background-color: var(--dark-theme);
            border-color: rgba(222, 228, 236, 0.07) !important;
        }
        .card-header i {
            display:block !important;
        }
        
</style>

<div class="container" >
  <div class="row">
    <div class="col-lg-12">
      <div class="card ">
        <div class="card-body">
            <form method="GET">
                    <div class="row" bis_skin_checked="1">
                      <div class="col-md-6 mt-2"><h5>Manage Transaction  <br> <span style="font-size: 12px;"> <?php echo $start_date ?> - <?php echo $end_date; ?></span></h5></div>
                      <div class="col-md-3 mt-2" bis_skin_checked="1">
                        <div class="input-group mb-2" bis_skin_checked="1">
                            <div class="row" bis_skin_checked="1">
                          <div class="input-group col-md-6" bis_skin_checked="1">
                               <b>From:</b>
                              <br>
                            <div class="input-group" bis_skin_checked="1">
                                <input class="form-control" name="start_date" id="start_date" value="<?php echo isset($start_date) ? $start_date : ''; ?>" placeholder="MM/DD/YYYY" type="date">
                            </div>
                          </div>
                          <div class="input-group col-md-6" bis_skin_checked="1">
                               <b>To:</b>
                              <br>
                              
                            <div class="input-group" bis_skin_checked="1">
                                <input class="form-control" name="end_date" id="end_date" value="<?php echo isset($end_date) ? $end_date : ''; ?>" placeholder="MM/DD/YYYY" type="date">
                            </div>
                          </div>
                          </div>
                        </div>
                      </div>
                      
                      <div class="col-md-2 mt-2">
                          <b>Transaction ID:</b><br>
                          <input type="text" class="form-control" name="search_txn"
                                 value="<?= $_GET['search_txn'] ?? ''; ?>"
                                 placeholder="Search Transaction ID">
                        </div>
                       <div class="col-md-1 mt-2" bis_skin_checked="1">
                          &nbsp; 
                        <br>
                        <button class="btn btn-primary buttons-excel buttons-html5" type="submit"><span>Apply</span></button>
                    </div>
                    </div>
            </form>
                   <div class="row">
                       <div class="col-md-12">
                            <ul class="pagination">
                                <?php
                                    $query_string = '';
                                    if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                                    if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                                
                                    // Previous Button
                                    if ($current_page > 1) {
                                        echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                                </a></li>';
                                    }
                                
                                    for ($i = 1; $i <= $total_pages; $i++) {
                                        if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                            $class = ($current_page == $i) ? 'active' : '';
                                            echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                                        } elseif ($i == 2 || $i == $total_pages - 1) {
                                            echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                                        }
                                    }
                                
                                    // Next Button
                                    if ($current_page < $total_pages) {
                                        echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                                    }
                                ?>
                    </ul>
                       </div>
                   </div> 
                    <div class="table-responsive" bis_skin_checked="1">
                    <table id="file-datatable" class="border-top-0 table table-bordered text-nowrap key-buttons border-bottom dataTable no-footer" role="grid" aria-describedby="file-datatable_info">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Customer Name</th>
                                <th>Date</th>
                                <th>Time</th>
                                <th>Transaction id</th>
                                <th>Card</th>
                                <th>Payment Amount</th>
                                <th>Fee</th>
                                <th>Total Payment</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                
                                $counter = $offset+1;
                                if (mysqli_num_rows($result_transcations) > 0) {
                                  // output data of each row
                                  while($row_transcations = mysqli_fetch_assoc($result_transcations)) {
                                    $transaction_id  = $row_transcations['transaction_id'];
                                    $amount  = (float)$row_transcations['amount'];
                                    $card  = $row_transcations['card'];
                                    $date  = $row_transcations['date'];
                                    $fee_amount  = $row_transcations['fee_amount'];
                                    $amount_without_fee  = $row_transcations['amount_without_fee'];
                                    $time  = $row_transcations['time'];
                                    
                                    // Combine date and time to form a complete datetime string
                                    $dateTimeString = $date . ' ' . $time;
                                    
                                    // Convert the combined string to a timestamp
                                    $timestamp = strtotime($dateTimeString);
                                    
                                    // Format date in US format (mm/dd/yyyy)
                                    $formatted_date = date('m/d/Y', $timestamp);
                                    
                                    // Format time in 12-hour format (hh:mm:ss AM/PM)
                                    $formatted_time = date('h:i A', $timestamp);
                                    
                            ?>
                                <tr>
                                <td><?php echo $counter; ?></td>
                                <td><?php echo $customer_name; ?></td>
                                <td><?php echo $formatted_date; ?></td>
                                <td><?php echo $formatted_time; ?></td>
                                <td><?php echo $transaction_id; ?></td>
                                <td><?php echo $card; ?></td>
                                <td>$<?php echo $amount_without_fee; ?></td>
                                <td>$<?php echo $fee_amount; ?></td>
                                <td>$<?php echo $amount ? number_format($amount, 2) : '0.00'; ?></td>
                                <td><?php echo $row_transcations['status']; ?></td>
                                <td>
                                    <a target="_blank" href="download_invoice.php?id=<?php echo $row_transcations['id'] ; ?>&transcation_id=<?php echo $transaction_id; ?>" title="Print">
                                          <i class="fas fa-print" style="color:red;"></i>
                                    </a>
                                </td>
                                </tr>
                                <?php 
                                    $counter++;
                                  }
                                }
                                ?>
                        </tbody>
                    </table>
                    <!-- Pagination -->
                    <ul class="pagination">
                    <?php
                        $query_string = '';
                        if (!empty($start_date)) $query_string .= '&start_date=' . urlencode($start_date);
                        if (!empty($end_date)) $query_string .= '&end_date=' . urlencode($end_date);
                        if (!empty($search_txn)) $query_string .= '&search_txn=' . urlencode($search_txn);

                        // Previous Button
                        if ($current_page > 1) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page - 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-left" style="font-size:12px;"></i>
                                        </a></li>';
                        }
                    
                        for ($i = 1; $i <= $total_pages; $i++) {
                            if ($i == 1 || $i == $total_pages || ($i >= $current_page - 1 && $i <= $current_page + 1)) {
                                $class = ($current_page == $i) ? 'active' : '';
                                echo '<li class="paginate_button page-item ' . $class . '"><a href="?page=' . $i . $query_string . '" class="page-link">' . $i . '</a></li>';
                            } elseif ($i == 2 || $i == $total_pages - 1) {
                                echo '<li class="paginate_button page-item disabled"><a href="#" class="page-link">...</a></li>';
                            }
                        }
                    
                        // Next Button
                        if ($current_page < $total_pages) {
                            echo '<li class="paginate_button page-item"><a href="?page=' . ($current_page + 1) . $query_string . '" class="page-link"><i class="fas fa-chevron-right" style="font-size:12px;"></i></a></li>';
                        }
                    ?>
                    </ul>

                </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php 
include "footer_above_section.php"; 
include "footer.php"; 
?>
