<?php
include('header.php');
$alert = "";

$card_id = isset($_GET['card_id']) ? (int)$_GET['card_id'] : 0;

if ($card_id <= 0) {
    die("❌ Invalid card ID.");
}

if (isset($_POST['submit'])) {
    $account_number = preg_replace('/\D/', '', $_POST['account_number']);
    $cvv = preg_replace('/\D/', '', $_POST['cvv']);
    if (strlen($cvv) !== 3) {
        die("❌ CVV must be exactly 3 digits.");
    }
    $expiry_input = $_POST['expiry_date'];

    if (!preg_match('/^\d{2}\/\d{2}$/', $expiry_input)) {
        die("❌ Invalid expiry format. Use MM/YY.");
    }

    $expiry_mmyy = str_replace('/', '', $expiry_input);
    $combined = $expiry_mmyy . $account_number . $cvv;
    $reversed = strrev($combined);

    $digitMap = [
        '0' => 'QWER', '1' => 'TYUI', '2' => 'ASDF', '3' => 'GHJK', '4' => 'ZXCV',
        '5' => 'BNMK', '6' => 'PLMO', '7' => 'IUYT', '8' => 'MNBC', '9' => 'REWQ'
    ];

    $encodedLetters = '';
    foreach (str_split($reversed) as $digit) {
        $encodedLetters .= $digitMap[$digit];
    }

    $charMap = [
        'A' => 1001, 'B' => 1002, 'C' => 1003, 'D' => 1004, 'E' => 1005,
        'F' => 1006, 'G' => 1007, 'H' => 1008, 'I' => 1009, 'J' => 1010,
        'K' => 1011, 'L' => 1012, 'M' => 1013, 'N' => 1014, 'O' => 1015,
        'P' => 1016, 'Q' => 1017, 'R' => 1018, 'S' => 1019, 'T' => 1020,
        'U' => 1021, 'V' => 1022, 'W' => 1023, 'X' => 1024, 'Y' => 1025, 'Z' => 1026
    ];

    $numbers = '';
    for ($i = 0; $i < strlen($encodedLetters); $i++) {
        $char = $encodedLetters[$i];
        if (!isset($charMap[$char])) {
            die("❌ Invalid character in encoding: $char");
        }
        $numbers .= $charMap[$char];
    }

    $firstbase64 = base64_encode($numbers);
    $secondbase64 = base64_encode($firstbase64);

    // Now update the card
    $update_query = "UPDATE `saved_cards_endc` SET `encrypted` = '$secondbase64' WHERE id = $card_id AND user_id = '$login_user_id'";
    if (mysqli_query($conn, $update_query)) {
        $alert = '<div class="alert alert-success" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Success!</strong> Card has been updated.
        </div>';
    } else {
        $alert = '<div class="alert alert-danger" role="alert">
            <button aria-label="Close" class="btn-close" data-bs-dismiss="alert" type="button">
                <span aria-hidden="true">×</span>
            </button>
            <strong>Error!</strong> Failed to update card. Please try again.
        </div>';
    }
}
?>

<!-- HTML Form (same as add card form) -->
<div class="row">
    <div class="col-lg-12 col-md-12">
        <div class="card">
            <div class="card-body">
                <div class="main-content-label mg-b-5">
                    Update Card<br><br>
                </div>
                <?php echo $alert; ?>
                <form method="POST">
                    <div class="row row-xs formgroup-wrapper">
                        <div class="col-md-4 mg-t-20">
                            <label class="form-label">Card Number</label>
                            <input class="form-control" type="text" name="account_number" id="account_number" maxlength="19" required placeholder="1234-5678-9012-3456" pattern="\d{4}-\d{4}-\d{4}-\d{4}">
                        </div>
                        <div class="col-md-4 mg-t-20">
                            <label class="form-label">CVV</label>
                            <input class="form-control" type="text" name="cvv" maxlength="3" required pattern="\d{3}" placeholder="Enter CVV">
                        </div>
                        <div class="col-md-4 mg-t-20">
                            <label class="form-label">Expiry</label>
                            <input class="form-control" type="text" name="expiry_date" id="expiry_date" maxlength="5" required placeholder="MM/YY" pattern="\d{2}/\d{2}">
                        </div>
                        <div class="col-md-12"> <hr> </div>
                        <div class="col-md-12">
                            <input class="form-control btn btn-primary" name="submit" type="submit" value="Update Card">
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

        <script>
        const input = document.getElementById('account_number');
        input.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '').slice(0, 16);
            let formatted = '';
            for (let i = 0; i < value.length; i++) {
                if (i > 0 && i % 4 === 0) formatted += '-';
                formatted += value[i];
            }
            e.target.value = formatted;
        });
        
        const expiryInput = document.getElementById('expiry_date');
        expiryInput.addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '').slice(0, 4);
            if (value.length >= 3) value = value.slice(0, 2) + '/' + value.slice(2);
            e.target.value = value;
        });
        
        document.getElementsByName('cvv')[0].addEventListener('input', function(e) {
            e.target.value = e.target.value.replace(/\D/g, '').slice(0, 3);
        });
        </script>

<?php include 'footer.php'; ?>
