<?php 
include "company_info.php";
$theme_color = "#364c62";
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name='viewport' content='width=device-width, initial-scale=1.0, user-scalable=0'>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="Description" content="">
    <meta name="Author" content="">
    <meta name="Keywords" content=""/>
    <title><?php echo $user_name; ?></title>

    <link rel="icon" href="admin/assets/img/<?php echo $user_logo; ?>" type="image/x-icon"/>

    <!-- Bootstrap css -->
    <link href="customer/assets/plugins/bootstrap/css/bootstrap.css" rel="stylesheet" id="style"/>
    <link href="customer/assets/css/style.css" rel="stylesheet">
    <link href="customer/assets/css/icons.css" rel="stylesheet">
    <link href="customer/assets/css/animate.css" rel="stylesheet">

    <style>
    :root {
        --dark-theme: #2b3054!important;
        --dark-body: #3d425d!important;
        --primary-bg-color: #364c62!important;
    }
    
    .app-sidebar .slide.is-expanded .side-menu__item {
        background: var(--primary-bg-color)!important;
    }
    
    .main-content:after {
        content: "";
        height: 220px;
        background: var(--primary-bg-color)!important;
    }
    
    .header-img {
        background: var(--primary-bg-color);
        border-top-left-radius: 4px;
        border-top-right-radius: 4px;
        padding: 10px 0;
        box-shadow: 0 3px 10px 1px rgba(0,0,0,0.1);
    }
    
    .slide:hover .side-menu__item, 
    .side-menu__item.active, 
    .side-menu__item:hover, 
    .side-menu__item:focus {
        background: var(--primary-bg-color);
    }
    
    .hero-image {
        background-image: linear-gradient(rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.5)), 
                          url("https://northcentralsolidwasteauthoritynm.municipalonlinepayments.com/northcentralsolidwasteauthoritynm/images/Banner?t=637092564386716539");
        height: 400px;
        background-position: center;
        background-repeat: no-repeat;
        background-size: cover;
        position: relative;
    }
    
    .hero-text {
        text-align: center;
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        color: white;
    }
    
    .services-section {
        position: relative;
        top: -50px;
        z-index: 1;
        padding: 20px;
        margin: 0 10px;
    }
    
    .card {
        border: none;
        border-radius: 10px;
        padding: 20px;
        background-color: #ffffff;
        box-shadow: 0 4px 8px rgba(0,0,0,0.2);
        margin-bottom: 20px;
    }
    @media (max-width: 767px) {
        .main-header {
            background:#364c62!important;
        }
    }
    </style>

</head>

<body class="main-body app sidebar-mini ltr">

<!-- page -->
<div class="page custom-index">

    <!-- main-header -->
    <div class="main-header side-header sticky nav nav-item" style="padding-left:0px; background:<?php echo $theme_color;?>">
        <div class="container-fluid main-container">
            <div class="main-header-left">
                <div class="" data-bs-toggle="sidebar">
                    <a class="desktop-logo logo-light active" href="index.php">
                        <img src="admin/assets/img/<?php echo $user_logo; ?>" class="main-logo" alt="logo" style="padding-left:10px; height:3rem;">
                    </a>
                </div>
                <div class="responsive-logo">
                    <a href="index.php" class="header-logo">
                        <img src="admin/assets/img/<?php echo $user_logo; ?>" class="logo-11">
                    </a>
                    <a href="index.php" class="header-logo">
                        <img src="admin/assets/img/<?php echo $user_logo; ?>" class="logo-1">
                    </a>
                </div>
            </div>

            <div class="mb-0 navbar navbar-expand-lg navbar-nav-right responsive-navbar navbar-dark p-0 mg-lg-s-auto" style="padding-right:10px;">
                <a href="customer/login.php">
                    <button type="button" class="btn btn-light btn-sm">Sign In / Register</button>
                </a>
            </div>
        </div>
    </div>
    <!-- /main-header -->

    <!-- main-content -->
    <div class="main-content app-content" style="margin-left:0px;">
        <div class="main-container">
            <div class="main-content-body">

                <!-- Hero Section -->
                <div class="hero-image">
                    <div class="hero-text">
                        <h1><?php echo $user_name; ?>, NM</h1>
                    </div>
                </div>
                <!-- /Hero Section -->

                <!-- Services Section -->
                <div class="services-section">
                    <div class="container">
                        <div class="row">
                            <div class="col-md-8">
                                <div class="card text-center">
                                    <h3>Welcome to our online payments website!</h3>
                                    <p>The following services are available:</p>
                                    <p><strong>• <?php echo $user_name; ?> Billing</strong></p>
                                    <a href="customer/login.php" class="btn btn-primary">Sign In /  Register</a>
                                    
                                    
                                    <br>
                                    <br>
                                    <br>
                                    
                                    
                                </div>
                                
                                
                                
                                
                                    
                            </div>

                            <div class="col-md-4">
                                <div class="card text-center">
                                    <h3>Available services</h3>
                                    <p><strong><?php echo $user_name; ?> Billing</strong></p>
                                </div>
                                
                                <div class="card text-center">
                                    <h3>Welcome</h3>
                                    <p>Welcome to our online payments website.</p>
                                </div>
                            </div>
                            
                            <div class="col-md-12">
                                
                                     <div style="background-color: #ffffff; border-left: 6px solid #2e86de; padding: 20px; max-width: 100%; margin: auto; box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);">

                                            <h3 >
                                              Notice to Our Valued Customers
                                            </h3>
                                        
                                            <div style="font-size: 16px; line-height: 1.6; color: #333333;">
                                              <p>The North Central Solid Waste Authority's current accounting software provider has implemented changes that require us to migrate to a new online bill-payment platform.</p>
                                        
                                              <p>We are pleased to announce that we have partnered with a Local Santa Fe-based company to continue delivering secure, convenient payment services.</p>
                                        
                                              <p style="font-weight: bold; margin-top: 20px;">What this means for you:</p>
                                              <ul style="padding-left: 20px;">
                                                <li style="margin-bottom: 8px;">One-time registration: You will need to create a new account on the updated payment portal—just once.</li>
                                                <li style="margin-bottom: 8px;">eBilling: Choose paperless statements.</li>
                                                <li style="margin-bottom: 8px;">Autopay: Schedule automatic payments.</li>
                                                <li style="margin-bottom: 8px;">Real-time alerts: Opt to receive payment confirmations and reminders via email or SMS.</li>
                                              </ul>
                                        
                                              <p>Thank you for your understanding as we make this transition. We are confident the new platform will offer a smoother, more flexible payment experience.</p>
                                        
                                              <p style="margin-top: 20px;"><strong>- NCSWA Management</strong></p>
                                            </div>
                                        
                                          </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /Services Section -->

            </div> <!-- End main-content-body -->
        </div> <!-- End main-container -->
    </div> <!-- End main-content -->
    <!-- /page -->

    <!-- Footer -->
   	<div class="main-footer ht-45" style="height:175px">
			<div class="container-fluid pd-t-0-f ht-100p">
				<!--<span> Copyright © 2024. <a href="javascript:void(0);" class="text-primary"></a> Designed with <span class="fa fa-heart text-danger"></span> by <a href="javascript:void(0);"> ADB </a> All rights reserved.</span>-->
				 <img src="customer/assets/img/copyright.png" style="height:80px;margin-top:30px"><br><a href="http://Govproprocessing.net" target="_blank"> Gov Pro Processing Copyright <?php echo date('Y');?> </a> All rights reserved.</span>
			</div>
		</div>
    <!-- /Footer -->

</div> <!-- End page -->

<!-- Back-to-top -->
<a href="#top" id="back-to-top"><i class="las la-angle-double-up"></i></a>

<!--- JS Scripts --->
<script src="customer/assets/plugins/jquery/jquery.min.js"></script>
<script src="customer/assets/plugins/jquery-ui/ui/widgets/datepicker.js"></script>
<script src="customer/assets/plugins/bootstrap/popper.min.js"></script>
<script src="customer/assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="customer/assets/plugins/ionicons/ionicons.js"></script>
<script src="customer/assets/plugins/chart.js/Chart.bundle.min.js"></script>
<script src="customer/assets/plugins/jquery-sparkline/jquery.sparkline.min.js"></script>
<script src="customer/assets/js/chart.flot.sampledata.js"></script>
<script src="customer/assets/js/eva-icons.min.js"></script>
<script src="customer/assets/plugins/moment/moment.js"></script>
<script src="customer/assets/plugins/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="customer/assets/plugins/perfect-scrollbar/p-scroll.js"></script>
<script src="customer/assets/plugins/side-menu/sidemenu.js"></script>
<script src="customer/assets/js/sticky.js"></script>
<script src="customer/assets/plugins/sidebar/sidebar.js"></script>
<script src="customer/assets/plugins/sidebar/sidebar-custom.js"></script>
<script src="customer/assets/plugins/raphael/raphael.min.js"></script>
<script src="customer/assets/plugins/morris.js/morris.min.js"></script>
<script src="customer/assets/js/script.js"></script>
<script src="customer/assets/js/index.js"></script>
<script src="customer/assets/js/themecolor.js"></script>
<script src="customer/assets/js/swither-styles.js"></script>
<script src="customer/assets/js/custom.js"></script>

</body>
</html>